//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.5 page-365
//Topic     : Turbulent Pipe Flow
//Caption   : Air flows through a tube under fully developed condition

//===================================================
package Ex6_5

model Ex6_5_a
extends Modelica.Math;

//Parameter
parameter Real d(unit="cm") = 14    "Diameter-tube";
parameter Real uo(unit="m/s") = 5   "Centerline velocity";
parameter Real K(unit="-") = 0.41   "Kama Constant";
parameter Real B(unit="-") = 5      "Constant B";

//Given: Properties of air at 20deg.C
parameter Real rho(unit="kg/m^3") = 1.205   "Density-air";
parameter Real v(unit="m^2/s") = 0.0000151  "kinematic viscosity-air";

//Variable  
Real ustar(unit="m/s")  "Frictional velocity";
Real R(unit="m")    "Radius";

//Equation
equation
R=(d/2)/100;

//USING: Eq. 6.28
uo/ustar=((1/K)*log(R*ustar/v))+ B;

//===================================================
end Ex6_5_a;
//===================================================

model Ex6_5_b
extends Ex6_5_a;

//Variable Ex6_5_b
Real j(unit="Pa") "Wall shear stress";

//Equation Ex6_5_b
equation
j = rho*(ustar^2);

//===================================================
end Ex6_5_b;
//===================================================
end Ex6_5;
//===================================================
