//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.8 page-373
//Topic     : Turbulent Pipe Flow
//Caption   : Checking for turbulent flow possibility for  a smooth walled pipe

//===================================================
model Ex6_8

extends Modelica.Math;

//Parameter
parameter Real rho_g(unit="lbf/ft^3") = 58 "Specific weight-liquid";
parameter Real alpha2(unit="-") = 2 "Kinetic energy coefficent"; //From Eq. 3.76

final constant Real g(unit="ft/s^2") = 32.2 "Gravity-acceleration";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//DATA: For alpha=1.06
parameter Real alpha(unit="-") = 1.06 "Kinetic energy coefficent";

//Given: Fig. E6.4
parameter Real L(unit="ft") = 1         "Length-tank";
parameter Real d(unit="ft") = 0.004     "Diameter-tank";
parameter Real Q(unit="ft^3/h") = 0.15  "Volumetric flow rate";
parameter Real z1(unit="ft") = 2        "Distance-section1";
parameter Real z2(unit="ft") = 0        "Distance-section2";

//===================================================

//Variable

Real rho(unit="slug/ft^3")  "Density-liquid";
Real V(unit="ft/s")         "Velocity";
Real hf(unit="ft")          "Head loss";
Real mew(unit="slug/ft.s")  "Viscosity-liquid";

Real rey1(unit="-")         "Reynolds number"; //Equation 6.38
Real rey2(unit="-")         "Reynolds number"; //Equation 6.39b

Real f(unit="-")            "Friction factor";
Real rey_d(unit="-")        "Reynolds number for laminar flow";

Real hf2(unit="-")  "Kinetic energy coefficent";
Real f2(unit="-")   "Friction factor for hf2";

//===================================================

//Equation

equation

rho=(rho_g/g);
V=(Q/3600)/((pi/4)*(d^2));

hf=(z1-z2)-(alpha2*V^2/(2*g));
hf2=(z1-z2)-(alpha*V^2/(2*g));

f=(hf*d*2*g)/(L*(V^2));
f2=(hf2*d*2*g)/(L*(V^2));

rey_d=(64/f);

((1/sqrt(f2))+0.8)=(2*log10(rey1*sqrt(f2)));

f2=(1.8*log10(rey2/6.9))^(-2);


mew=(rho*V*d)/((rey1+rey2)/2);

//=================================================== 
end Ex6_8;
//===================================================
