//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 7 : Flow Past Immersed Bodies
//Example   : 7.1 page-460
//Topic     : Reynolds Number and Geometry Effects
//Caption   : A long, thin flat plate.

//===================================================
model Ex7_1
extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter
parameter Real s(unit="in") = 1 "Boundary leayer thickness";
parameter Real U(unit="ft/s") = 20 "Stream velocity";

//DATA: Table A.1
parameter Real v(unit="ft^2/s") = 0.00001082 "Kinematic viscosity-water";

//===================================================

//Variable

Real x1(unit="ft") "Distance-Laminar flow";
Real rey1(unit="-") "Reynolds number-Laminar flow";

Real x2(unit="ft") "Distance-Turbulent flow";
Real rey2(unit="-") "Reynolds number-Turbulent flow";

//===================================================

//Equation 

equation

//EQUATIONS: Eq.(7.1a) and Eq.(7.1b)

//For LAMINAR flow
(s*0.0833/x1)=(5)/((U*x1/(v))^0.5); //CONVERSION: in to ft
rey1=(U*x1/v);

//For TURBULENT flow
(s*0.0833/x2)=(0.16)/((U*x2/(v))^0.14285);
rey2=(U*x2/v);

//===================================================
end Ex7_1;
//===================================================
