//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 7 : Flow Past Immersed Bodies
//Example   : 7.3 page-470
//Topic     : The Flat-Plate Boundary Layer
//Caption   : A sharp flat plate.

//===================================================
package Ex7_3

model Ex7_3_a

//Parameter
parameter Real L(unit="cm") = 50 "Length-plate";
parameter Real b(unit="m") = 3 "Breadth-plate";
parameter Real U(unit="m/s") = 2.5 "Velocity";

//DATA: Table A.2 for Air @ 20deg.C
parameter Real rhoa(unit="kg/m^3") = 1.2 "Density-air";
parameter Real mewa(unit="m^2/s") = 0.000015 "Kinematic viscosity-air";

//DATA: Table A.1 for Water @ 20deg.C
parameter Real rhow(unit="kg/m^3") = 998 "Density-water";
parameter Real meww(unit="m^2/s") = 0.000001005 "Kinematic viscosity-water";

//===================================================

//Variable

Real reyL(unit="-") "Trailing edge Reynolds number-air";
Real s(unit="m") "Thickness-air";
Real CD(unit="-") "Drag coefficient-air";
Real D_one_side(unit="N") "Force-air";

//===================================================

//Equation

equation

reyL=(U*(L/100))/mewa;

// reyL < (5*10^5) ---> using Eq. 7.24
(s/(L/100))=(5/((reyL)^0.5));

//From Eq. 7.27
CD=(1.328/((reyL)^0.5));

D_one_side=(CD*(rhoa/2)*(U^2)*b*(L/100));

//===================================================
end Ex7_3_a;
//===================================================

model Ex7_3_b
extends Ex7_3_a;

//===================================================

//Variable

Real reyLw(unit="-") "Reynolds number-trailing edge-water";
Real sw(unit="m") "Thickness-water";
Real CDw(unit="-") "Drag coefficient-water";
Real Dw_one_side(unit="N") "Force-water";

//===================================================

//Equation

equation

reyLw=(U*(L/100))/meww;
(sw/(L/100))=(5/((reyLw)^0.5));
CDw=(1.328/((reyLw)^0.5));
Dw_one_side=(CDw*(rhow/2)*(U^2)*b*(L/100));

//===================================================
end Ex7_3_b;
//===================================================
end Ex7_3;
//===================================================
