//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 7 : Flow Past Immersed Bodies
//Example   : 7.6 page-490
//Topic     : Experimental External Flows
//Caption   : A square piling is acted on by a water flow.

//===================================================
model Ex7_6

//Parameter
parameter Real L(unit="ft") = 20 "Length of the column";
parameter Real V(unit="ft/s") = 5 "Velocity of water";
parameter Real h(unit="in") = 6 "Breadth";

//GIVEN: Fig. E7.6
parameter Real rho(unit="slugs/ft^3") = 1.99 "Density-water";
parameter Real mew(unit="ft^2/s") = 0.000011 "Kinematic viscosity-water";
parameter Real w(unit="ft") = 0.5 "Piling width";

//DATA: Table 7.2
parameter Real CD(unit="-") = 2.1 "Discharge coefficient";

//===================================================

//Variable

Real reyh(unit="-") "Reynolds number";
Real A(unit="ft^2") "Frontal area";
Real F(unit="lbf") "Drag force";
Real Mo(unit="ft.lbf") "Momentom-bottom";
Real S(unit="lbf/in^2") "Bending stress";

//===================================================

//Equation

equation

reyh=(V*w)/(mew);
A=(L*w);
F=(CD)*(0.5*rho*V*V*A);
Mo=(F*L)/2;
S= ((Mo*(w/2))/((w^4)/(12)))*(0.0833^2);

//===================================================
end Ex7_6;
//===================================================
