//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 7 : Flow Past Immersed Bodies
//Example   : 7.7 page-492
//Topic     : Experimental External Flows
//Caption   : The drag coefficient of a blimp.

//===================================================
model Ex7_7

//Parameter
parameter Real L(unit="m") = 75     "Length of blimp";
parameter Real A(unit="m^2") = 3400 "Surface area of blimp";
parameter Real U(unit="m/s") = 18   "Velocity";
parameter Real z(unit="m") = 1000   "Altitude";
parameter Real CD(unit="-") = 0.006 "Drag coefficient";

//DATA: Table A.6 at z=1000m
parameter Real rho(unit="kg/m^3") = 1.112       "Density of blimp";
parameter Real mew(unit="kg/m.s") = 0.0000175   "Viscosity of blimp";

//===================================================

//Variable

Real reyL(unit="-") "Reynolds number";
Real F(unit="N")    "Drag force";
Real P(unit="W")    "Power required to propel blimp";

//===================================================

//Equation

equation

reyL=(rho*U*L)/mew;
F=(CD)*(0.5*rho*U*U*A);
P=(F*U);

//===================================================
end Ex7_7;
//===================================================
