//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 7 : Flow Past Immersed Bodies
//Example   : 7.9 page-508
//Topic     : Experimental External Flows
//Caption   : An aircraft weighs 75000lbf.

//===================================================
model Ex7_9
extends ModelicaReference.Icons.Information;
extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//===================================================

//Parameter

parameter Real W(unit="lbf") = 75000 "Weight of airplane";
parameter Real A(unit="ft^2") = 2500 "Platform area";
parameter Real T(unit="lb") = 12000 "Thrust";
parameter Real CL(unit="-") = 2 "finite span lift";
parameter Real rho(unit="slug/ft^3") = 0.00237 "Density of sea=level";

//===================================================

//Variable

Real Vs(unit="ft/s") "Stall speed";
Real Vo(unit="ft/s") "Takeoff speed";
Real CLo(unit="-") "Initial span lift";
Real CDo(unit="-") "Initial drag coefficient";
Real k(unit="slugs/ft") "Mass/Length";
Real Do(unit="lbf") "Initial drag force";
Real m(unit="slugs") "Mass";
Real So(unit="ft") "Takeoff distance";

//===================================================

//Equation

equation

Vs=((2*W)/(CL*rho*A))^0.5;
Vo=(1.2*Vs);
//GIVEN: Aspect ratio=7
m=(W/g);
CLo=(W)/(0.5*rho*Vo*Vo*A);
CDo=((0.02)+(0.0455*(CLo^2)));
k=(CDo*0.5)*(rho*A);
Do=(k*(Vo^2));

So=((m/(2*k)))*log(T/(T-Do));

//===================================================
end Ex7_9;
//===================================================
