//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.10 page-646
//Topic     : Compressible Duct Flow with Friction
//Caption   : Air flows subsonically in an adiabatic duct

//===================================================
package Ex9_10

model Ex9_10_a

//Parameter 
parameter Real D(unit="cm") = 2     "Diameter of duct";
parameter Real f(unit="-") = 0.024  "Average friction factor";
parameter Real Ma1(unit="-") = 0.1  "Mach number of section-1";
parameter Real Ma2(unit="-") = 0.5  "Mach number of section-2";
parameter Real Ma3(unit="-") = 1    "Mach number of section-3";
parameter Real k(unit="-") = 1.4    "Constant";

//DATA: Table B.3
parameter Real C1(unit="-") = 66.9216   "Ratio Data-1";
parameter Real C2(unit="-") = 1.0691    "Ratio Data-2";

//Variable
Real del_L(unit="m") "Duct length";

//Equation
equation
//USING: Eq. 9.67
//DATA: Table B.3

(f*del_L/(D/100))=(C1-C2);

end Ex9_10_a;
//===================================================

model Ex9_10_b
extends Ex9_10_a;

//Variable Ex9_10_b
Real Del_L(unit="m") "Additional length";

///Equation Ex9_10_b
equation
(Del_L*f/(D/100))=(C2);

end Ex9_10_b;
//===================================================
end Ex9_10;
//===================================================
