//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.11 page-647
//Topic     : Compressible Duct Flow with Friction
//Caption   : For the duct flow of example 10

//===================================================
package Ex9_11
extends Modelica.Math;

model Ex9_11_a

//Parameter
parameter Real Ma1(unit="-") = 0.1 "Mach number upstream";
parameter Real Ma2(unit="-") = 0.5 "Mach number downstream";

parameter Real p1(unit="kPa") = 600 "Pressure upstream";
parameter Real T1(unit="K") = 450   "Temperature upstream";

//DATA: Table B.3 for respective Mach number and Eq. 9.68
//Variable for Ma1=0.1
Real p1_ratio(unit="-") "Pressure ratio for Ma1";
Real T1_ratio(unit="-") "Temperature ratio for Ma1";
Real V1_ratio(unit="-") "Velocity ratio for Ma1";

//Variable Ma1=0.5
Real p2_ratio(unit="-") "Pressure ratio for Ma2";
Real T2_ratio(unit="-") "Temperature ratio for Ma2";
Real V2_ratio(unit="-") "Velocity ratio for Ma2";


//DATA:
parameter Real R(unit="m^2/s^2.K") = 287 "Air rate constant";
parameter Real k(unit="-") = 1.4    "Constant";

//Variable
Real V1(unit="m/s")     "Velocity upstream";
Real po1(unit="kPa")    "Stagnation pressure upstream";
Real p2(unit="kPa")     "Pressure downstream";
Real po1_ratio(unit="-")"Stagnation Pressure ratio for  Ma1";
Real po2_ratio(unit="-")"Stagnation Pressure ratio for  Ma2";

//Equation
equation
V1=Ma1*sqrt(k*R*T1);

//For Ma1
p1_ratio = (1/Ma1)*((k+1)/(2+(k-1)*Ma1*Ma1))^0.5;
1/V1_ratio = (1/Ma1)*sqrt((2+(k-1)*Ma1*Ma1)/(k+1));
po1_ratio = (1/Ma1)*((2+(k-1)*Ma1*Ma1)/(k+1))^(0.5*((k+1)/(k-1)));
T1_ratio = (k+1)/(2+(k-1)*Ma1*Ma1);

//For Ma2
p2_ratio = (1/Ma2)*((k+1)/(2+(k-1)*Ma2*Ma2))^0.5;
1/V2_ratio = (1/Ma2)*sqrt((2+(k-1)*Ma2*Ma2)/(k+1));
po2_ratio = (1/Ma2)*((2+(k-1)*Ma2*Ma2)/(k+1))^(0.5*((k+1)/(k-1)));
T2_ratio = (k+1)/(2+(k-1)*Ma2*Ma2);

po1=p1*(1+0.2*Ma1*Ma1)^3.5;
p2=p1*(p2_ratio/p1_ratio);


end Ex9_11_a;
//===================================================

model Ex9_11_b
extends Ex9_11_a;

//Variable Ex9_11_b
Real T2(unit="K") "Temperature downstream";

//Equation Ex9_11_b
equation
T2=T1*(T2_ratio/T1_ratio);

end Ex9_11_b;
//===================================================

model Ex9_11_c
extends Ex9_11_b;
extends Ex9_11_a;

//Variable Ex9_11_c
Real V2(unit="m/s") "Velocity downstream";

//Equation Ex9_11_c
equation
V2=V1*(V2_ratio/V1_ratio);

end Ex9_11_c;
//===================================================

model Ex9_11_d
extends Ex9_11_a;
extends Ex9_11_c;
extends Ex9_11_b;

//Variable Ex9_11_d
Real po2(unit="kPa") "Stagnation pressure downstream";

//Equation Ex9_11_d
equation
po2=po1*(po2_ratio/po1_ratio);

end Ex9_11_d;
//===================================================
end Ex9_11;
//===================================================
