model Ex11_1
//Example 11.1
//Fracture Toughness
//Page No. 354
import Modelica.Constants.*;
import Modelica.Math.*;
parameter Real a(unit ="mm") = 5"Depth";
parameter Real t(unit = "mm")=12"thickness";
parameter Real K_Ic(unit = "MPa*m^(1/2)")=24"Fracture toughness";
Real a1(unit = "m")"Depth";
Real t1(unit = "m")"thickness";
Real x;
Real sigma(unit ="Mpa")"stress";
equation
a1=a*10^(-3);             
t1=t*10^(-3);        
x=1/cos(pi*a1/(2*t1));        
sigma=K_Ic/sqrt(pi*a1*x);
//As applied stress is 172 Mpa. Hence flaw will propogate as brittle fracture.
end Ex11_1;
