model Ex12_1
//Example 12.1
//Mean Stress
//Page No. 387
import Modelica.Constants.*;
parameter Real sigma_u(unit="Mpa") =1090"Ultimate strength";
parameter Real sigma0(unit="Mpa")=1010"Yield stress";
parameter Real sigma_e(unit="Mpa") =510"Yield strength";
parameter Real l_max(unit="kN")  =330"Axial load";
parameter Real l_min(unit="kN") =-110"Axial load";
parameter Real sf =2.5;
Real sigma_m(unit="Mpa")"Mean stress";
Real sigma_a(unit="Mpa")"Alternating stress";
Real sigma_e1(unit="Mpa")"Yield strength" ;
Real A(unit="mm^2")"area";
Real D(unit="mm")"diameter";
equation
sigma_m=(l_max/1000+l_min/1000)/2;
sigma_a=(l_max/1000-l_min/1000)/2;
sigma_e1=sigma_e/sf;
A=(sigma_a/sigma_e1+sigma_m/sigma_u)*10^(6);
D=sqrt(4*A/pi);
end Ex12_1;
