model Ex12_3
//Example 12.3
//Fatigue Crack Proportion
//Page No. 401
import Modelica.Constants.*;
parameter Real ai(unit = "m") = 0.0005"crack length";
parameter Real sigma_max(unit = "MPa")=180"Stress";
parameter Real Kc(unit = "MPam^(1/2)")=100"Fracture toughness" ;
parameter Real alpha=1.12;
parameter Real p=3"Slope";
parameter Real A(unit = "MPam^(1/2)")=6.9*10^(-12);
Real af(unit = "m")"fatigue crack length";
Real Nf(unit = "cycles")"Number of fatigue cycles";
equation
af=(Kc/(sigma_max*alpha))^2/pi;
Nf=(af^(1-(p/2))-ai^(1-(p/2)))/((1-p/2)*A*sigma_max^3*pi^(p/2)*alpha^p);
//Ans is wrong in book
end Ex12_3;
