model Ex12_4
//Example 12.4
//Stress Concentration of Fatigue
//Page No. 404
import Modelica.Constants.*;
parameter Real rho =0.01"Neuber's Constant";
parameter Real S_u(unit = "Mpa") = 1310"Strength level";
parameter Real M(unit = "Nm")=40"Bending momenT";
parameter Real Pm(unit = "kN")=20"Axial steady load";
parameter Real D(unit = "mm")=12"Diamter of shaft";
parameter Real dh(unit = "mm")=1.2"Diameter of hole";
parameter Real Kt=2.2"stress Concentration factor";
Real r(unit = "mm")"Radius";
Real Kf"fatigue notch factor";
Real q"Notch Sensitivity factor";
Real A(unit="mm^2")"Area";
Real sigma_m(unit="Mpa")"steady stress";
Real sigma_a(unit="Mpa")"bending stress";
Real sigma_max(unit="Mpa")"Maximum stress";
Real sigma_min(unit="Mpa")"Minimum stress";
Real sigma_e(unit = "Mpa")"Yield strength";
Real sigma_a1(unit = "Mpa");
equation
r=dh/2;
Kf=1+(Kt-1)/(1+sqrt(rho/r));
q=(Kf-1)/(Kt-1);
A=pi/4*D^2;
sigma_m=Pm/A*10^(3);
sigma_a=Kf*((M*D)/(2*pi/64*D^4))*10^(3);
sigma_max=sigma_a+sigma_m;
sigma_min=sigma_a-sigma_m;
sigma_e=S_u/2;
sigma_a1=sigma_e/Kf*(1-sigma_m/S_u);
//Ans varies due to rounding off values in book
end Ex12_4;
