model Ex2_1
//Example 2.1
//State of Stress in two dimensions
//Page No. 25
  import Modelica.SIunits.Conversions.*;
  parameter Real theta(unit = "degrees") = from_deg(45)"Theta";
  parameter Real sigma_x_(unit = "Mpa") = 50"Normal Stress";
  parameter Real T_x_y_(unit = "Mpa") = 5"Shear Stress";
  Real p(unit = "pa")"Pressure";
  Real T_xy(unit = "Mpa")"Shear Stress";
  Real sigma_x(unit = "Mpa")"Normal Stress";
  Real sigma_y(unit = "Mpa")"Normal Stress";
  Real sigma_y_(unit = "Mpa")"Normal Stress";
  equation
  sigma_x_ = (sigma_x + sigma_y)/2 + (sigma_x  + sigma_y) / 2 * cos(2 * theta) + T_xy * sin(2 * theta);
  sigma_x = 25 * p;
  sigma_y = 5 * p;
  T_x_y_ = (sigma_y - sigma_x) / 2 * sin(2 * theta) + T_xy * cos(2 * theta);
  sigma_y_ + sigma_x_=sigma_x + sigma_y;

end Ex2_1;
