model Ex21_2
//Example 21.2
//Mechanics of Machining
//Page No. 687
import Modelica.SIunits.Conversions.*;
import Modelica.Math.*;
import Modelica.Constants.*;
parameter Real v(unit = "m/sec") = 2.5"Shear velocity";
parameter Real alpha(unit = "degrees") = from_deg(6)"Rake angle";
parameter Real b(unit = "m") = 10*10^(-3)"width of cut";
parameter Real t(unit = "um") = 200"thickness";
parameter Real Fv(unit = "N") = 440"force";
parameter Real Fh(unit = "N") = 1100"force";
parameter Real L(unit = "m") = 500*10^(-3)"length";
parameter Real rho(unit = "kg/m^3") = 7830"density";
parameter Real m(unit = "gm") = 13.36;
Real tc(unit = "mm")"Chip Thickness";
Real r"Chip thickness ratio";
Real fi(unit = "Radian")"Shear angle";
Real fi1(unit = "degree")"Shear angle";
Real be(unit = "Radian");
Real be1(unit = "degree");
Real Pr(unit = "N");
Real Ft(unit = "N")"Tangential force";
Real p_fe(unit = "N");
Real Fs(unit="N")"shearing force";
Real vs(unit="m/sec")"shear velocity";
Real p_se(unit="%")"% shearing energy";
Real U;
equation
tc=(m*10^(-3)/(rho*b*L))*10^3;
r=t*10^(-3)/tc;
tan(fi)=(r*cos(alpha)/(1-r*sin(alpha)));
fi1=to_deg(fi);
tan(be)=(Fv+Fh*tan(alpha))/(Fh-Fv*tan(alpha));
be1=to_deg(be);
Pr=sqrt(Fv^2+Fh^2);
Ft=Pr*sin(be1*pi/180);
p_fe=Ft*r/Fh;
Fs=Fh*cos(fi)-Fv*sin(fi);
vs=v*cos(alpha)/cos(fi-alpha);
p_se=(Fs*vs/(Fh*v))*100;
U=(Fh*v/(b*t*10^(-6)*v))*10^(-6);
end Ex21_2;
