model Ex3_1
//Example 3.1
//True Stress and True Strain
//Page No. 76
import Modelica.Constants.*;
parameter Real D_i(unit = "m") = 12*10^(-3)"Initial Diamter";
parameter Real P_max(unit = "N") = 90*10^3"Pressure";
parameter Real P_f(unit = "N") = 70*10^3"Pressure";
parameter Real D_f(unit = "m") = 10*10^(-3)"Minimum diameter at fracture";
Real E_St(unit = "MPa")"Engineering stress at maximum load";
Real T_fr_St(unit = "MPa")"True fracture stress";
Real e_f"True strain at fracture";
Real ef"Engineering strain at fracture";
equation
E_St= P_max*4/(pi*D_i^2)*10^(-6);
T_fr_St= P_f*4/(pi*D_f^2)*10^(-6);
e_f=2*log(D_i/D_f);
ef=exp(e_f)-1;
end Ex3_1;
