model Ex4_1
//Example 4.1
//Critical Resolved Shear Stress for Slip
//Page No. 125
  parameter Real a[3] = {1,-1,0}"Axis";
  parameter Real n[3] = {1,-1,-1}"Axis";
  parameter Real s[3] = {0,-1,-1}"Axis";
  parameter Real Tr(unit = "MPa") = 6"Shear Stress";
  Real cos_fi"Angle between Tensile axis and normal direction";
  Real cos_lm"Angle between Tensile axis and Slip direction";
  Real sigma(unit = "MPa")"Tensile stress";
  equation
  cos_fi=sum(a .* n)/(sqrt(a[1]^2+a[2]^2+a[3]^2)*sqrt(n[1]^2+n[2]^2+n[3]^2));
  cos_lm=sum(a.*s)/(sqrt(a[1]^2+a[2]^2+a[3]^2)*sqrt(s[1]^2+s[2]^2+s[3]^2));
  sigma=Tr/(cos_fi*cos_lm);

end Ex4_1;
