model Ex8_1
//Example 8.1
//Standard properties of the material
//Page No. 281
import Modelica.Constants.*;
parameter Real D(unit = "mm") = 13"Diameter";
parameter Real Lo(unit = "mm") = 50"gage length";
parameter Real Lf(unit = "mm") = 65"gage length at fracture";
parameter Real Py(unit = "kg") = 6800"load";
parameter Real Pmax(unit = "kg") = 8400"Maximum load";
parameter Real Pf(unit = "kg") = 7300"load at which fracture occurs";
parameter Real D_f(unit = "mm") = 8"Diameter after fracture";
Real A0(unit = "m")"Orignal area";
Real Af(unit = "m")"area after fracture";
Real s_u(unit = "MPa")"Ultimate tensile strength";
Real s0(unit = "MPa")"offset yield strength";
Real s_f(unit = "MPa")"Breaking stress";
Real e_f(unit = "%")"elongation";
Real q(unit = "%")"Reduction of area" ;
equation
A0=(pi*D^2/4)*10^(-6);
Af=pi*D_f^2/4*10^(-6);
s_u=(Pmax*9.81/A0)*10^(-6);
s0=Py*9.81/A0*10^(-6);
s_f=Pf*9.81/A0*10^(-6);
e_f=((Lf-Lo)/Lo)*100;
q=((A0-Af)/A0)*100;
//Ans varies slighlty due to approximation in book.
end Ex8_1;
