model Ex11_3
//Example 11.3
//Plasticity
//Page No. 361
import Modelica.Constants.*;
parameter Real a0(unit = "mm") = 20"Crack length";
parameter Real sigma(unit = "Mpa")=400"Stress";
parameter Real sigma0(unit = "Mpa")=1500"Yield strength";
parameter Real sigma0_1(unit = "Mpa")=750"Yield strength";
Real a1(unit = "m")"Crack length";
Real rp(unit = "m")"Radius of plastic zone";
Real rp1(unit = "mm")"Radius of plastic zone";
Real K_eff(unit = "Mpa m^1/2")"Stress intensity factor";
Real K_eff1(unit = "Mpa m^1/2")"Stress intensity factor";
equation
a1=a0*10^(-3)/2;                 //conversion to m
rp=sigma^2*a1/(2*pi*sigma0^2);
rp1=rp*1000;                      //conversion to mm
K_eff=sigma*sqrt(pi*a1)*sqrt(1+(sigma^2)/(2*sigma0^2));
// if sigma0 is changed to 700 Mpa
K_eff1=sigma*sqrt(pi*a1)*sqrt(1+(sigma^2)/(2*sigma0_1^2));

end Ex11_3;
