model Ex12_6
//Example 12.6
//Local Strain method
//Page No. 424
parameter Real K(unit = "Mpa") = 1300"cyclic strength coefficient";
parameter Real n =0.12"cyclic strain hardening coefficient";
parameter Real ef =1.06"fatigue ductility coefficient";
parameter Real sigma_f(unit = "Mpa") = 1310"fatigue strength coefficient";
parameter Real b =-0.08"fatigue strength exponent";
parameter Real c =-0.66"fatigue ductility  exponent";
parameter Real E(unit = "GPa") = 205"Elastic Modulus";
Real E1(unit = "Pa")"Elastic Modulus";
Real s(unit = "MPa")"start-up overload stress";
Real sigma_m(unit = "Mpa")"Mean Stress";
Real sigma_a(unit = "Mpa")"Alternating Stress";
Real se(unit = "MPa")"Constant";
Real ds(unit = "MPa")"stress";
Real de"stress";
Real N2(start = 1);
Real N2_1;
Real N_1;
Real de_e2"stress";
Real N22(unit="cycles");
Real N2_2"damages per year";
Real C_pd"cycles produced in 1 day";
Real f(unit="days");
equation
E1=E*10^3;       
s=1380;            
sigma_m=1150;         
sigma_a=115;           
se=s^2/E1;
se/2= (ds^2/(2*E1))+(ds*(ds/(2*K))^(1/n));
de=se/ds;
(2*N2)^(b) * (sigma_f / E1) + ef * (2*N2)^(c) = de/2;
N2_1=1/N2;
N_1=N2/2;
de_e2=sigma_a/E1;
ef*(2*N22)^c+(((sigma_f-sigma_m)/E1)*(2*N22)^b)=de_e2;
N2_2=1/N22;
C_pd=2*60*60*8;
f=N22/C_pd;


end Ex12_6;
