model Ex17_3
//Example 17.3
//Rolling Load
//Page No. 599
parameter Real h0(unit = "mm") = 40"Thickness slab";
parameter Real mu = 0.3"coefficient of friction";
parameter Real D(unit = "mm") =900"Diameter";
parameter Real s_en(unit = "MPa") = 140"plane-strain flow stress at entrance";
parameter Real s_ex(unit = "MPa") = 200"plane-strain flow stress at exit";
parameter Real C(unit = "Pa^-1") = 2.16*10^(-11);
parameter Real P_(unit = "tons") = 13.4*10^6;
parameter Real w(unit = "m")=0.76"width";
Real h1(unit = "mm")"Final Thickness of  slab";
Real dh(unit = "mm")"change in thickness of  slab";
Real h_(unit = "mm")"mean thickness of  slab";
Real R(unit = "m")"Radius of curvature";
Real R1(unit = "m")"Radius of curvature";
Real Lp(unit = "mm")"Length of arc";
Real Q;
Real sigma0(unit = "Mpa") "mean strain";
Real P2(unit = "MN")"rolling load";
Real R2(unit="m")"Deformed radius";
equation
h1=h0-0.3*h0;
dh=(h0-h1)/1000;
h_=(h1+h0)/2;
R=D/(2*1000);
R1=R*(1+(C*P_/(w*dh)));
Lp=sqrt(R1*dh);
Q=(mu*Lp/h_)*1000;
sigma0=(s_en+s_ex)/2;
P2=sigma0*((exp(Q)-1)*w*Lp/Q);
R2=R*(1+C*P2*10^6/(w*dh));

end Ex17_3;
