model Ex17_4
//Example 17.4
//Torque and Horsepower
//Page No. 614
  import Modelica.Constants.*;
  parameter Real w(unit = "mm") = 300"width";
  parameter Real hi(unit = "mm") = 20"thickness";
  parameter Real hf(unit = "mm") = 15"thickness";
  parameter Real D(unit = "mm") = 1000"diameter";
  parameter Real N(unit = "rpm") = 100"Rotation per minute";
  Real R(unit = "mm")"Radius";
  Real dh(unit = "mm")"change in thickness of  slab";
  Real e1"strain rate";
  Real r"reduction";
  Real sigma(unit = "MPa")"Uniaxial flow stress";
  Real Qp"Complex function of reduction";
  Real P(unit = "MN")"rolling load";
  Real a(unit = "m")"Ratio of moment arm";
  Real W(unit = "MW")"power";
  equation
  R=D/2;
  dh=abs(hf-hi);
  e1=log(hi/hf);
  r=(hi-hf)/hi;
  sigma=140 * e1^0.2  / 1.2;
  Qp=1.5;                        
  P=(2*sigma*w*(R*(hi-hf))^(1/2)*Qp/sqrt(3))*10^(-6);
  a=0.5*sqrt(R*dh)/1000;
  W=(4*pi*a*P*N/60);

end Ex17_4;
