model Ex2_3
//Example 2.4
//Elastic Anisotropy
//Page No. 60
parameter Real S11_Fe(unit = "1/Tpa") = 8"Elastic Constants";
parameter Real S12_Fe(unit = "1/TPa") = -2.8"Elastic Constants";
parameter Real S44_Fe(unit = "1/TPa") = 8.6"Elastic Constants";
parameter Real S11_W(unit = "1/TPa") = 2.6"Elastic Constants";
parameter Real S12_W(unit = "1/TPa") = -0.7"Elastic Constants";
parameter Real S44_W(unit = "1/TPa") = 6.6"Elastic Constants";
parameter Real D_100_l =1"Direction cosine in cubic lattice";
parameter Real D_100_m =0"Direction cosine in cubic lattice";
parameter Real D_100_n =0"Direction cosine in cubic lattice";
parameter Real D_110_l =1/sqrt(2)"Direction cosine in cubic lattice";
parameter Real D_110_m =1/sqrt(2)"Direction cosine in cubic lattice";
parameter Real D_110_n =0"Direction cosine in cubic lattice";
parameter Real D_111_l =1/sqrt(3)"Direction cosine in cubic lattice";
parameter Real D_111_m =1/sqrt(3)"Direction cosine in cubic lattice";
parameter Real D_111_n =1/sqrt(3)"Direction cosine in cubic lattice";
Real Fe_E_111(unit = "Gpa")"Modulus of elasticity";
Real Fe_E_100(unit = "Gpa")"Modulus of elasticity";
Real W_E_111(unit = "Gpa")"Modulus of elasticity";
Real W_E_100(unit = "Gpa")"Modulus of elasticity";
equation
Fe_E_111=(1/(S11_Fe-2*((S11_Fe-S12_Fe)-S44_Fe/2)*(D_111_l^2*D_111_m^2+D_111_n^2*D_111_m^2+D_111_l^2*D_111_n^2)))*1000;
Fe_E_100=(1/(S11_Fe-2*((S11_Fe-S12_Fe)-S44_Fe/2)*(D_100_l^2*D_100_m^2+D_100_n^2*D_100_m^2+D_100_l^2*D_100_n^2)))*1000;
W_E_111=(1/(S11_W-2*((S11_W-S12_W)-S44_W/2)*(D_111_l^2*D_111_m^2+D_111_n^2*D_111_m^2+D_111_l^2*D_111_n^2)))*1000;
W_E_100=(1/(S11_W-2*((S11_W-S12_W)-S44_W/2)*(D_100_l^2*D_100_m^2+D_100_n^2*D_100_m^2+D_100_l^2*D_100_n^2)))*1000;
//Ans are rounded of in book
end Ex2_3;
