package Ex6_4
//Example 6.4
//Load Transfer
//Page No. 225
  model Ex6_4_a
    parameter Real sigma_fu(unit = "GPa") = 5 "composite  strength";
    parameter Real sigma_m(unit = "MPa") = 100 "composite  strength";
    parameter Real T0(unit = "MPa") = 80 "yield stress";
    parameter Real f_f = 0.5 "Volume fraction of fibre";
    parameter Real d(unit = "um") = 100 "Diamter";
    parameter Real L(unit = "m") = 0.1 "length";
    parameter Real L1(unit = "m") = 4 * 10 ^ (-3) "length";
    Real sigma_fu1(unit = "Pa") "composite  strength";
    Real sigma_m1(unit = "Pa") "composite  strength";
    Real T01(unit = "Pa") "yield stress";
    Real d1 "Diamter";
    Real Lc(unit = "m") "length";
    Real sigma_cu(unit = "Gpa") "composite  strength";
    Real sigma_cu1(unit = "Gpa") "composite  strength";
  equation
    sigma_fu1 = sigma_fu * 10 ^ 9;
    sigma_m1 = sigma_m * 10 ^ 6;
    T01 = T0 * 10 ^ 6;
    d1 = d * 10 ^ (-6);
    Lc = sigma_fu1 * d1 / (2 * T01);
    sigma_cu = (sigma_fu1 * f_f * (1 - Lc / 2 * L) + sigma_m1 * (1 - f_f)) * 10 ^ (-9);
    sigma_cu1 = (sigma_fu1 * f_f * (1 - Lc / L1) + sigma_m1 * (1 - f_f)) * 10 ^ (-9);
  end Ex6_4_a;




  model Ex6_4_b
    parameter Real sigma_fu(unit = "GPa") = 5 "composite  strength";
    parameter Real sigma_m(unit = "MPa") = 100 "composite  strength";
    parameter Real T0(unit = "MPa") = 80 "yield stress";
    parameter Real f_f = 0.5 "Volume fraction of fibre";
    parameter Real d(unit = "um") = 100 "Diamter";
    parameter Real L1(unit = "m") = 4 * 10 ^ (-3) "length";
    Real sigma_fu1(unit = "Pa") "composite  strength";
    Real sigma_m1(unit = "Pa") "composite  strength";
    Real T01(unit = "Pa") "yield stress";
    Real d1 "Diamter";
    Real Lc(unit = "m") "length";
    Real sigma_cu(unit = "Gpa") "composite  strength";
  equation
    sigma_fu1 = sigma_fu * 10 ^ 9;
    sigma_m1 = sigma_m * 10 ^ 6;
    T01 = T0 * 10 ^ 6;
    d1 = d * 10 ^ (-6);
    Lc = sigma_fu1 * d1 / (2 * T01);
    sigma_cu = (sigma_fu1 * f_f * (1 - Lc / L1) + sigma_m1 * (1 - f_f)) * 10 ^ (-9);
  end Ex6_4_b;





































end Ex6_4;
