model Ex17_2
//Example 17.2
//Rolling Load
//Page No. 598
import Modelica.Math.*;
parameter Real h0(unit = "mm") = 40"Thickness of  slab";
parameter Real Per=30;
parameter Real mu = 0.3"coefficient of friction";
parameter Real D(unit = "mm") =900"Diameter";
parameter Real s_en(unit = "MPa") = 140"plane-strain flow stress at entrance";
parameter Real s_ex(unit = "MPa") = 200"plane-strain flow stress at exit";
parameter Real w(unit = "m")=0.76"width";
Real h1(unit = "mm")"Final Thickness of  slab";
Real dh(unit = "mm")"change in thickness of  slab";
Real h_(unit = "mm")"mean thickness of  slab";
Real Lp"Length of arc";
Real Q;
Real sigma0(unit = "Mpa")"mean strain";
Real P(unit = "MN")"rolling load";
Real P1(unit = "MN")"rolling load";
Real R(unit = "m")"Diameter";
equation
R=D/2*10^(-3);
((h0-h1)/h0)*100=Per;
dh=h0-h1;
h_=(h1+h0)/2;
Lp=sqrt(D/2*dh);
Q=mu*Lp/h_;
sigma0=(s_en+s_ex)/2;
P=sigma0*(1/Q*(exp(Q)-1)*w*sqrt((D/2*10^(-3))*(dh*10^(-3))));
P1=sigma0*(sqrt(R*(dh*10^(-3)))/(4*h_*10^(-3))+1)*w*sqrt(R*(dh*10^(-3)));
end Ex17_2;
