model Ex18_1
//Example 18.1
//Extrusion Process
//Page No. 629
import Modelica.Math.*;
import Modelica.Constants.*;
import Modelica.SIunits.Conversions.*;
parameter Real Db(unit = "mm") = 150"Diameter";
parameter Real Df(unit = "mm") = 50"Diameter";
parameter Real L(unit = "mm") = 380"length";
parameter Real v(unit = "mm/s") = 50;
parameter Real mu =0.1"friction coefficient";
Real Alpha(unit="Radian")"semidie angle";
Real R"Extrusion ratio";
Real e(unit="1/sec")"mean strain";
Real sigma(unit="MPa")"stress";
Real B"constant";
Real p_d(unit="MPa")"Extrusion pressure";
Real t_i(unit="MPa");
Real p_e(unit="MPa")"Extrusion pressure";
Real P(unit="MN")"Extrusion load";
equation
Alpha=from_deg(60);
R=Db^2/Df^2;
e=6*v*log(R)/Db;
sigma=200*e^0.15;
B=mu*1/tan(Alpha);
p_d=abs(sigma*((1+B)/B)*(1-R^(B)));
t_i=sigma/sqrt(3);
p_e=(p_d)+4*t_i*L/Db;                   
P=p_e*pi/4*(Db/1000);
//Ans is wrong in book for Pd value
end Ex18_1;
