model Ex19_1
//Example 19.1
//Analysis of Wiredrawing
//Page No. 640
import Modelica.SIunits.Conversions.*;
import Modelica.Constants.*;
import Modelica.Math.*;
parameter Real Ab(unit = "mm") = 10"radius of wire";
parameter Real r(unit = "%") = 0.2"Percent reduction";
parameter Real alpha(unit = "degrees") = 12"die angle";
parameter Real mu = 0.09"friction coefficient";
parameter Real n =0.3"exponent";
parameter Real K(unit = "MPa") = 1300"flow stress";
parameter Real v(unit = "m/s") = 3"velocity";
Real alpha1(unit = "radian")"die angle";
Real B"constant";
Real e1"strain";
Real sigma(unit="MPa")"stress";
Real Aa(unit="mm")"radius of billet";
Real sigma_xa(unit="MPa")"draw stress";
Real sigma_xa1(unit="MPa")"draw stress";
Real Pd(unit="KN")"Drawing force";
Real P(unit="KW")"power";
equation
alpha1=from_deg(12);
B=mu/tan(alpha1/2);
e1=log(1/(1-r));
sigma=K*e1^0.3/(n+1);
Aa=Ab*(1-r);
sigma_xa=sigma*((1+B)/B)*(1-(Aa/Ab)^B);
sigma_xa1=sigma*log(Ab/Aa)*(1+B);
Pd=(sigma_xa*pi/4*(Aa)^2)/1000;
P=Pd*v;
//Ans varies slightly due to approximation in book.
end Ex19_1;
