model Ex6_2
//Example 6.2
//Strengthing Mechanism
//Page No. 219
parameter Real sigma0(unit = "MPa") = 600"Yield stress";
parameter Real G(unit = "GPa") = 27.6"Shear Modulus";        
parameter Real b(unit = "m") = 2.5*10^(-10);
Real G1(unit = "Pa")"Shear Modulus";
Real b1(unit = "m");
Real T0(unit = "MPa")" stress required to force dislocation";
Real T01(unit = "Pa")" stress required to force dislocation";
Real lambda(unit = "m")"interparticle spacing";
Real lambda1(unit="nm")"interparticle spacing";
Real Cu_max(unit = "%")"% weight";
Real Cu_eq(unit = "%")"% weight";
Real Cu_min(unit = "%")"% weight";
Real rho_al(unit = "kg/m^3")"Density";
Real rho_theta(unit = "kg/m^3")"Density";
Real wt_a"% weight of alpha phase";
Real wt_theta"% weight of  theta phase";
Real V_a(unit = "m^3")"volume of alpha phase";
Real V_theta(unit = "m^3")"volume of  theta phase";
Real f"Volume fraction";
Real z"Volume fraction of theta ";
Real r(unit = "nm")"radius";
equation
G1=G*10^9 ;
b1=b*10^(-2);            
T0=sigma0/2;
T01=T0*10^6;             
lambda=G1*b/T01;
lambda1=lambda*10^(9);
Cu_max=54;             
Cu_eq=4;               
Cu_min=0.5;             
rho_al=2700;             
rho_theta=4430;           
wt_a=((Cu_max-Cu_eq)/(Cu_max-Cu_min))*100;
wt_theta=((Cu_eq-Cu_min)/(Cu_max-Cu_min))*100;
V_a=wt_a/rho_al;
V_theta=wt_theta/rho_theta;
f=V_theta/(V_a+V_theta);
z=V_a/(V_a+V_theta);
r=((3*f*lambda)/(4*(1-f)))*10^(9);
end Ex6_2;
