model Ex10_8
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>The top surface of a slab of margarine, 50 mm thick, initially at a temperture of 4 C is kept exposed to an ambient at 25C. Heat transfer to the slab occurs from the top surface only and the otehr surfaces may be considered insulated. If the heat transfer coefficient at the open surface is 8 Kcal/h m^2 C, calculate the bottom surface, midplane and top surface temperatures of the slab after 4 hours. The relevent physical properties of margarine are<div>density=990 Kg/m^3</div><div>Cp=0.55 Kcal/Kg</div><div>k=0.143 Kcal/h m C.</div></body></html>"));
//Data are taken from the figures given in the problem
parameter Real l(unit="m")=0.05"Length";
parameter Real ro(unit="Kg/m^3")=990"Density of margarine";
parameter Real Cp(unit="Kcal/Kg C")=0.55"Specific heat of margarine";
parameter Real k(unit="Kcal/h m C")=0.143"Thermal conductivity of margarine";
parameter Real Ti(unit="C")=4"Initial temperature";
parameter Real To(unit="C")=25"Ambient temperature";
parameter Real t(unit="m")=0.1"Thickness of the slab";
parameter Real t_ex(unit="h")=4"Time of exposure";
parameter Real h(unit="Kcal/h m^2 C")=8"heat transfer coefficient";
parameter Real Tc_bar=0.7; //from fig 10.6 (a)"Heat transfer principles and applications by binay K dutta"
Real Fo"Fourier Number";
Real alpha(unit="m^2/s")"Thermal diffusivity";
Real Bi"Biot Number";
Real Tc(unit="C")"Center temperature";
Real Tp(unit="C")"Temperature of the top surface";
Real Tm(unit="C")"Temperature of the mid plane";
equation
alpha=(k/(ro*Cp));
Fo=((alpha*t_ex)/(l^2));
Bi=((h*l)/(k));
Tc_bar=((Tc-To)/(Ti-To));
((Tp-To)/(Tc-To))=0.382;  //0.382 is taken from fig 10.6 (b)
((Tm-To)/(Tc-To))=0.842;  //0.842 is taken from fig 10.6 (b)
end Ex10_8;
