model Ex2_1
  annotation(
    Documentation(info = "<html><head></head><body>The wall of a Cold Storage consisting of three layers an outer layer of ordinary brick,25 cm thick, a middle layer of cork, 10cm thick and an inner layer of cement, 6cm thick. The thermal conductivities of the meterials are brick:0.7,cork:0.044,and cement:0.72 W/m C. The temperature of the outer surface of the wll is 30 C and that of the inner is -15 C. Calculate&nbsp;<div>a) the steady state of heat gain per unit area of the wall&nbsp;</div><div>b)The temperature of the interfaces of the composite wall and&nbsp;</div><div>c) The percentage of the total heat transfer resistance offered by the individual layers. What additional thickness of the cork should be provided to make the rate of heat transfer 30% less than the present value.</div></body></html>"));
//Problem statements is given in the Documentation view
  Real R1(unit = "C/W") "Resistance offered to the Heat Transfer by Brick";
  Real R2(unit = "C/W") "Resistance offered to the Heat Transfer by Cork";
  Real R3(unit = "C/W") "Resistance offered to the Heat Transfer by Cement";
  Real R(unit = "C/W") "Total Resistance";
  Real DelT(unit = "C") "Driving Force";
  Real Q(unit = "W") "Heat Transfer Rate";
  Real T1(unit = "C") "Temperature across The Cork and Cement Wall";
  Real T2(unit = "C") "Temperature across the Brick and Cork wall";
  Real Pc(unit = "%") "Percentage of thermal Resistance offered by Cement";
  Real Pco(unit = "%") "Percentage of thermal Resistance offered by Cork";
  Real Pb(unit = "%") "Percentage of thermal Resistance offered by Brick";
  Real t(unit = "cm") "Additional thickness of the Cork to get 30% less Heat transfer rate";
  parameter Real l1(unit = "m") = 0.25 "Leangth of the Brick wall";
  parameter Real l2(unit = "m") = 0.1 "Leangth of the Cork wall";
  parameter Real l3(unit = "m") = 0.06 "Leangth of the Cement wall";
  parameter Real K1(unit = "W/m2 K") = 0.7 "Thermal Conductivity of Brick wall";
  parameter Real K2(unit = "W/m2 K") = 0.043 "Thermal Conductivity of Cork wall";
  parameter Real K3(unit = "W/m2 K") = 0.72 "Thermal Conductivity of Cement wall";
  parameter Real Tin(unit = "C") = -15 "Inside Temperature";
  parameter Real Tout(unit = "C") = 30 "Temperature Out";
equation
  R1 = l1 / K1;
  R2 = l2 / K2;
  R3 = l3 / K3;
  R = R1 + R2 + R3;
  DelT = Tout - Tin;
/*Sub division a */
  Q = DelT / R;
/*Sub division b */
  Q = (Tout - T2) / R1;
  Q = (Tout - T1) / (R1 + R2);
/*Sub division c */
  Pb = R1 / R * 100;
  Pco = R2 / R * 100;
  Pc = R3 / R * 100;
  Q * (1 - 0.3) = DelT / (R1 + R2 + R3 + t * 10 ^ (-2) / K2);
  //There may be a chance of slight changes in the ans from book due to the approximation in the book ans
end Ex2_1;
