model Ex3_10
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A 3 inch schedule 40 caron steel pipe (Actual i.d=78mm, wall thickness=5.5 mm) has eight longitudinal fins of 1.5 mm thickness. Each fin extends 30 mm from the pipe wall. The thermal conductivity of the fin material is 45 W/m C. If the wall temperature, The ambient temperature and the surface heat transfer coefficient are 150 C, 28 C and 75 W/m^2 C respectively, calculate the percentage increase in the rate of heat transfer for the finned tube over the plain tube.</body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real h(unit="W/m^2 C")=75   "Heat transfer coefficient";
parameter Real k(unit="W/m C")=45     "Thermal conductivity";
parameter Real w(unit="m")=0.0015     "Thickness of the fin";
parameter Real l(unit="m")=0.03       "Breadth of the fin";
parameter Real n=8                    "Number of fins";
parameter Real Tb(unit="C")=150       "base wall temperature";
parameter Real Ta(unit"C")=28         "Ambient temperature";
parameter Real i_d(unit="m")=0.078    "Inner diameter of the pipe";
parameter Real t(unit="m")=0.0055     "Thickmess of the pipe";
Real m(unit="m^-1")                   "temporary variable";
Real efficiency                       "Efficiency of the fin";
Real area(unit="m^2")                 "Area of single fin";
Real Qf(unit="W")                     "Ideal Heat transfer rate on fin";
Real Qaf(unit="W")                    "Actual heat transfer rate on fin";
Real Ap(unit="m^2")                   "Convective Area of the pipe without fin";
Real Apf(unit="m^2")                  "Convective Area of the pipe with fin";
Real o_d(unit="m")                    "Outer diameter of the pipe";
Real Qwf(unit="W")                    "Total Heat Trabsfer rate with fin";
Real Q(unit="W")                      "Total Heat transfer rate without fin";
Real p(unit="%")                      "Percentage increase in heat transfer due to fin";

equation

m=sqrt((2*h)/(k*w));
efficiency=((1/(m*l))*tanh(m*l));
// 1m length of the fin is considered
area=2*1*l;                        //both side are taken and edges are neglected
Qf=h*area*n*(Tb-Ta);
Qaf=Qf*efficiency;
o_d=i_d+2*t;
Ap=2*pi*(o_d/2)*1;
Apf=Ap-(n*(1*w));
Qwf=(h*Apf*(Tb-Ta))+Qaf;            // Heat transfer rate with fin 
Q=h*Ap*(Tb-Ta);
p=((Qwf-Q)/Q)*100;
end Ex3_10;
