model Ex3_12
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A copper wire, 5.2 mm in diameter, is insulated with a layer of PVC (polyvinyl Chloride) of thermal conductivity kc=0.43 W/m C. The wire carries current, and its temperature is 60 C. The film coefficent at the outer surface of the insulation is 11.35 W/ m^2 C. Calculate the critical insulation thickness.</body></html>"));
//Data are given in book (pg.no 84)-Heat trasnfer : Principles and applications by Binay K Dutta
parameter Real ri(unit="m")=(5.2/2)*10^(-3)"Inner radius of insulation";
parameter Real ho(unit="W/m^2 C")=11.35"Surface heat transfer coefficient";
parameter Real Kc(unit="W/m C")=0.43"Thermal conductivity of PVC";
Real rc(unit="m")"Critical radius of insulation";
Real tc(unit="m")"Critical insulation radius";
equation
rc=(Kc/ho);
tc=(rc-ri);
end Ex3_12;
