model Ex3_4
//Problem statements is given in the Documentation view
final constant Real pi=2*Modelica.Math.asin(1.0);
  annotation(
    Documentation(info = "<html><head></head><body>A stream pipe of 97 mm inner diameter and 114 mm outer diamter (4 inch,schedule 80), is required to carry high pressure saturated steam at 30 bar absolute pressure. It is covered by a layer of mineral wool in order to reduce heat loss. Though an extra thick layer of insulation saves a lot of heat, iot is expensive at outer surface of the insulation (also called the skin engineer usually allows the temperature at the outer surface of the insulation (also called the skin temperature) to remain at 15-25 C above the room temperature. In order to calculate the thickness of insulation of the above steam pipe, assume a skin temperature of 55 C. The ambient temperature is 30 C. the thermal conductivity of mineral wool may be taken as 0.1 W/m C, And that of the pipe material (Carbon steel) as 43 W/mC. The external air-film coefficient for heat loss to the ambinet is 8 W/m^2 C. Calculate the thickness of the insulation &nbsp;and the rate of heat loss per meter length of the pipe.</body></html>"));
parameter Real ri(unit="m")=(97/2)*(10^(-3)) "Inner diameter of pipe";
parameter Real r1(unit="m")=(114/2)*(10^(-3))"Outer diamter of pipe";
parameter Real kc(unit="W/m C")=0.1"thermal conductivity of insulation";
parameter Real kw(unit="W/mC")=43"Thermal conductivity of pipe";
parameter Real h(unit="W/m^2 C")=8 "Heat transfer coefficient";
parameter Real Ti(unit="C")=234 "Steam Temperature";
parameter Real Ts(unit="C")=55 "Skin temperature";
parameter Real To(unit="C")=30"Ambient temperature";
Real R (unit="C/W")"Heat transfer resistance";
Real DF(unit="c")"Driving Force";
Real Q(unit="W")"Heat transfer rate";
Real ro(unit="m")"Outer radius of the insulation";
Real t(unit="m")"Thickness of the insulation";
equation
//total thermal resistance
R=(1/(2*pi))*(((log(ro/r1))/(kc))+((log(r1/ri))/(kw)));
DF=(Ti-Ts);
Q=DF/R;
Q=2*pi*ro*h*(Ts-To);
t=ro-r1;
end Ex3_4;
