model Ex3_5
//Problem statements is given in the Documentation view
 annotation(
    Documentation(info = "<html><head></head><body>An 8% solution of alcohol from fermenter is raised to 75 C in a heat exchanger before feeding it to the distilation column for concentration. A 50 mm (Schedule 40 IPS) pipe is used to carry the hot liquid to the column. The pipe is insulated with a 4 cm thick layer of glass fibre banket (k=0.068 W/m C). The liquid-side film coefficient is estimated to be 800w/m<sup>2 </sup>C, and the outer air-film coefficient is 10 W/m<sup>2</sup>C. The thermal coductivity of the liquid mixture (alcohol and water) can be calculated by using the filippov equation k<sub>m</sub>=w<sub>1</sub>k<sub>1</sub>+w<sub>2</sub>k<sub>2</sub>-0.72w<sub>1</sub>w<sub>2</sub>(|k<sub>1</sub>-k<sub>2</sub>|), where w<sub>1</sub>&nbsp;and w<sub>2</sub>&nbsp;are the weight fractions of components 1 and 2 having thermal conductivity k<sub>1</sub>&nbsp;and k<sub>2</sub>&nbsp;respectively. The following data are also available : ambient air temperature = 28 C, actual pipe diameter : i.d=53 mm, o.d=60mm. Thermal conductivity values are - pipe wall: 45 W/m C, air:0.0263 W/m C, alcohol:0.155 W/m C, and water: 0.67 W/m C. Calculate<div><br></div><div>(a) the effective thickness of the air and the 'liquid films'.</div><div>(b) the overall heat transfer coefficient based on the i.d of the pipe,</div><div>(c) the overall heat transfer coeffience based on the o..d of the insulation,</div><div>(d) the percentage o the total resistance offered by the 'air film</div><div>(e) the rate of heat lost per metre length of yhe pipe</div><div>(f) the insulation 'skin temperature'.</div></body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real w1=0.08 "weight fraction of alcohol";
parameter Real w2=0.92 "weight fraction of water";
parameter Real k1(unit="W/m C")=0.155 "Thermal conductivity of alcohol";
parameter Real k2(unit="W/m C")=0.67 "Thermal conductivity of water";
parameter Real hi (unit="W/m^2 C")=800 "Liquid side heat transfer coefficient";
parameter Real ho (unit="W/m^2 C")=10 "Outer air side heat transfer coefficient";
parameter Real ka (unit="W/m C")=0.0263 "Thermal conductivity of air";
parameter Real r1(unit="m")=0.03 "outer radius of pipe";
parameter Real ri(unit="m")=0.0265"Inner radius";
parameter Real t(unit="m")=0.04 "Thickness of insulation";
parameter Real kw(unit="W/m C")=45 "Thermal COnductivity of pipe wall";
parameter Real ki(unit="W/m C")=0.068 "Thermal Conductivity of insulation";
parameter Real Ti(unit="C")=75 "Inner temperature";
parameter Real To(unit="C")=28 "Outer temperature";
Real km (unit="W/m C") "Thermal conductivity of mixture";
Real delta1(unit="mm")"Effective thickness of liquid film";
Real delta2(unit="mm") "Effective thickness of air film";
Real Ai (unit="m^2") "Inner Convective area";
Real Ao (unit="m^2") "Outer Convective area";
Real ro(unit="m")"Outer radius of insulation";
Real Ui(unit="W/m^2 C") "Inner overall heat transfer coefficient";
Real Uo(unit="W/m^2 C")"Ourer overall Heat Transfer Coefficient";
Real Rov(unit="C/w")"Overall Heat transfer resistance";
Real Ra(unit="C/W")"Air Film Heat transfer resistance";
Real P(unit="%")"Percentage of air resistance";
Real Q(unit="W")"Rate of heat loss";
Real Ts(unit="C") "Insulation Skin temperature";
equation
//Subdivision (a)
//Thermal conductivity of the mixture
  km=w1*k1+w2*k2-0.72*w1*w2*(abs(k1-k2));
//effective thickness of liquid film
delta1=(km/hi)*1000;
//Effective thickness of the air film
delta2=(ka/ho)*1000;
//subdivision (b)
ro=r1+t;
(1/Ui)=(1/hi)+((Ai*log(r1/ri))/(2*pi*kw))+((Ai*log(ro/r1))/(2*pi*ki))+((Ai)/(Ao*ho));
Ai=2*pi*ri;
Ao=2*pi*ro;
//subdivision (c)
Ui*Ai=Uo*Ao;
//Subdivision (d)
//Total Heat Transfer resistance based on 1m length of pipe
Rov=(1/(Ui*Ai));
Ra=(1/(Ao*ho));
P=(Ra/Rov)*100;
//Subdivision (e)
Q=Ui*Ai*(Ti-To);
//Subdivision (f)
Q=ho*Ao*(Ts-To);
end Ex3_5;
