model Ex3_7
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A simple apparatus used for the experimental determination of vapour-liquid equilibrium data is the Othmer still. Heat is supplied to the still for vaporization of the liquid mixture; The vapour leaving the still is condensed and the condesate is recirculated to the still. After equilibrium is attained, samples of the liquid in the still and of the condensate are drawn and analyzed.<div>Given</div><div>a 2.5cm i.d glass tube of 0.3 cm wall thickness is used as the still. A 2.5 m long nichrome wire (Electrical resistance =16.7 ohm/m) is wound on a 0.12 m section of the glass tube over which there is a 2.5 cm thick layer of insulation. The thermal conductivity of glass tube over which there is a 2.5 cm thick layer of insulation. the thermal conductivity of glass is 1.4 W/m C, and that of the insulation is 0.041 W/m C. The temperature of the boiling liquid in the still is 91 C. The film coefficent of a boiling liquid is very large.The mbient temperature is 27 C and the outside air-film coefficient is 5.8 W/m^2 C. If the power is supplied to the heating coil at 90 V, what is the rate of heat input to the boiling liquid at steady state?</div></body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real Rc(unit="ohm")=16.7*2.5"Electrical resistance of the coil";
parameter Real V(unit="V")=90"Potential difference (Voltage)";
parameter Real ri(unit="m")=0.0125"Inner radius of the glass tube";
parameter Real r1(unit="m")=0.0155"outer radius of the glass tube";
parameter Real ro(unit="m")=0.0405"Outer radius of the insulation";
parameter Real L(unit="m")=0.12"Length of the still covered with heating coil";
parameter Real kg(unit="W/m C")=1.4"Thermal conductivity of glass";
parameter Real ki(unit="W/m C")=0.041"Thermal COnductivity of insulation";
parameter Real ho(unit="W/m^2 C")=5.8"Outside heat transfer coefficient";
parameter Real Ti(unit="C")=91"Temperature at inner surface of the glass tube";
parameter Real To(unit="C")=27"Ambient temperature";
Real Rg(unit="C/W")"Heat transfer resistance of the glass wall";
Real Ri(unit="C/W")"Heat transfer resistance of insulation";
Real Rf(unit="C/W")"Heat transfer resistance of air film";
Real Qe(unit="W")"Heat generation due to electrical energy";
Real Qb(unit="W")"Heat input rate for boiling";
Real Qi(unit="W")"Heat transfer rate through insulation";
Real Ts(unit="C")"Temperature of the outer surface";
equation
Qe=((V^2)/Rc);
Rg=((log(r1/ri))/(2*pi*L*kg));
Ri=((log(ro/r1))/(2*pi*L*ki));
Rf=(1/(2*pi*ro*L*ho));
Qb=((Ts-Ti)/Rg);
Qi=((Ts-To)/(Ri+Rf));
Qb+Qi=Qe;   
//Due to the approximation in the book there is a slight variation in the simulated result
end Ex3_7;
