model Ex4_10
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Hot engine oil has to be colled from 110 C to 70 C in a counterflow double-pipe heat exchanger at a rate of 500 Kg/h. The exchanger consists of a 25 mm (1 inch) 14 BWG inner tbe and a 35 mm (1-1/4 inch) schedule 40 outer pipe. The oil flows through the annulus and the cooling water flows through the tube, entering at 29 C and leaving at 40 C. Calculate the length of the heat exchanger.</body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
//Data are available in the problem statement
parameter Real dti(unit="m")=0.0212"Inner diameter of inner tube";
parameter Real dto(unit="m")=0.0254"Outer diameter of inner tube";
parameter Real dpi(unit="m")=0.035"inner diameter of outer pipe";
parameter Real ro_o(unit="Kg/m^3")=850"Density of oil";
parameter Real Cp_o(unit="Kcal/Kg C")=0.478"Specific heat oil";
parameter Real K_o(unit="Kcal/h m C")=0.12"Thermal conductivity of oil";
parameter Real K_w(unit="Kcal/h m C")=0.542"Thermal conductivity of water";
parameter Real vis_w(unit="Kg/m s")=7.1*10^(-4)"Viscosity of water";
parameter Real Cp_w(unit="Kcal/Kg C")=1"Kcal/Kg C";
parameter Real mo(unit="kg/h")=500"Oil flow rate";
parameter Real To1(unit="C")=70"Outlet temperature of oil";
parameter Real To2(unit="C")=110"Inlet temperature of oil";
parameter Real Tw1(unit="C")=29"Inlet temperature of water";
parameter Real Tw2(unit="C")=40"Outlet temperature of water";
parameter Real ro_w(unit="Kg/m^3")=1000"Density of water";
Real vis_o(unit="Kg/m S")"Viscosity of oil";
Real Q(unit="Kcal/h")"Heat load";
Real mw(unit="kg/h")"Water flow rate";
Real At(unit="m^2")"Flow area of tube";
Real Vw(unit="m/s")"Velocity of water";
Real Re_w"Reynolds number of water";
Real Pr_w"Prandtl Number of water";
Real Nu_w"Nusselt Number of water";
Real hi(unit="Kcal/h m^2 C")"Water side heat transfer coefficient";
Real As(unit="m^2")"Flow area of annulus";
Real Vo(unit="m/s")"Velocity of oil";
Real de(unit="m")"Equivelent diameter";
Real Tm(unit="C")"mean temperature of oil";
Real Re_o"Reynolds Number of oil";
Real Pr_o"Prandtl Number of oil";
Real Nu_o"Nusselt Number of oil";
Real ho(unit="Kcal/h m^2 C")"Oilside heat transfer coefficient";
Real Uo(unit="Kcal/h m^2 C")"Ouside overall coefficient";
Real Ao(unit="m^2")"Ouside heat transfer area";
Real L(unit="m")"Length of the heat exchanger";
Real LMTD(unit="C")"Log mean temperature difference";
Real Nu_o_1"Recalculation of oil nusselt numeber";
Real ho1(unit="Kcal/h m^2 C")"Recalculation of outside HTC";
Real Tm_w(unit="C")"Mean temperature of water";
Real Tw(unit="C")"Wall temperature";
Real vis_wall(unit="Kg/m s")"Viscosity of oil at  wall temperature";
Real Nu_o_2"Recalculation of oil final nusselt numeber";
Real ho2(unit="Kcal/h m^2 C")"Recalculation of final outside HTC";
Real Uo2(unit="Kcal/h m^2 C")"Final Outside Overall HTC";
Real L2(unit="m")"Final length of heat exchanger";
equation
Q=(mo*Cp_o*(To2-To1));
Q=(mw*Cp_w*(Tw2-Tw1));
//Tube side
At=((pi/4)*(dti^2));
Vw=((mw/(ro_w*3600))/At);
Re_w=((dti*Vw*ro_w)/vis_w);
Pr_w=(Cp_w*vis_w/(K_w/3600));
Nu_w=(0.023*(Re_w^0.8)*(Pr_w^0.4));
Nu_w=(hi*dti/K_w);
//Oil side
As=((pi/4)*((dpi^2)-(dto^2)));
Vo=((mo/(3600*ro_o))/(As));
de=(((dpi^2)-(dto^2))/dto);
Tm=(To1+To2)/2;
log(vis_o)=((5550/(Tm+273))-19);
Re_o=(de*Vo*ro_o/vis_o);
Pr_o=(Cp_o*vis_o/(K_o/3600));
Nu_o=3.66;
Nu_o=(ho*de/K_o);
//Overall heat transfer coefficient
Uo=(1/((1/ho)+((dto/dti)*(1/hi))));
Ao=(pi*dto*L);
Q=(Uo*Ao*LMTD);
LMTD=(((To1-Tw1)-(To2-Tw2))/(log((To1-Tw1)/(To2-Tw2))));
//Recalculation of length
Nu_o_1=(1.86*(((Re_o*Pr_o)/(L/de))^(1/3)));
Nu_o_1=(ho1*de/K_o);
//Wall temperature
Tm_w=(Tw1+Tw2)/2;
((ho1)*(pi*dto)*(Tm-Tw))=((hi)*(pi*dti)*(Tw-Tm_w));
log(vis_wall)=((5550/(Tm_w+273))-19);
//Final calculation of length
Nu_o_2=1.86*((((Re_o*Pr_o)/(L/de))^(1/3))*((vis_o/vis_wall)^(0.14)));
Nu_o_2=(ho2*de/K_o);
Uo2=(1/((1/ho2)+((dto/dti)*(1/hi))));
(pi*dto*L2*Uo2*LMTD)=(Q);
//due to the approximation in the book, there is slight difference in the simulated result with the book ans
end Ex4_10;
