model Ex4_11
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A large volume of exhaust gas available at 260 C is used to heat process water. The gas flow across a tube bank and water flows through the tubes. The outside diameter of the tube is 6 cm. The tube bank has 5 transverse rows and 14 longitudinal rows. The tubes are spaced 15 cm centre to centre in an equilateral triangular arrangement. The hot gas approaches the tube bank at a velocity of 16 m/s. If the tube surface temperature is 70 C, calculate the rate of heat transfer to water per meter length of th etube bank.</body></html>"));
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real ST(unit="m")=0.15 "Vertical spacing";
parameter Real SD(unit="m")=0.15 "diagonal spacing";
parameter Real V(unit="m/s")=16"Velocity of hot gas";
parameter Real d(unit="m")=0.06"outer diameter of the tube";
parameter Real ki_vis(unit="m^2/s")=(4.43*(10^(-5)))"Momentum diffusivity";
parameter Real density(unit="Kg/m^3")=0.73"Density of exhaust";
parameter Real Cp(unit="Kcal/kg C")=0.248"Specific heat of exhaust";
parameter Real k(unit="Kcal/h m C")=0.0375"Thermal conductivity of exhaust"; 
parameter Real Prw=0.7"Prandtl Number of air at wall temperature";
parameter Real NT=15"Number of tubes in a transverse row";
parameter Real n=14"Number of transverse rows";
parameter Real m=0.6"Constant";
parameter Real Ti(unit="C")=260"Inlet temperature of exhaust";
parameter Real Ts(unit="C")=70"Surface temperature";
parameter Real L(unit="m")=1"length of the tube";
Real SL(unit="m")"horizondal distance between two rows";
Real Pr"Prandtl Number";
Real N"Total Number of rows";
Real Vmax(unit="m/s")"Maximum velocity";
Real Re"Reynolds Number";
Real C"Constant";
Real h(unit="Kcal/h m^2 C")"Heat Transfer Coefficient";
Real To(unit="C")"Outlet temperature of exhaust";
Real LMTD(unit="C")"Log mean temperature difference";
Real A(unit="m")"Heat transfer area";
Real Q(unit="Kcal/hr")"Heat transfer rate";
equation
SL=((3^(1/2))/2)*SD;
Pr=(Cp*ki_vis*density/(k/3600));
N=n*NT;
Vmax=(ST/(ST-d))*V;
Re=(d*Vmax/ki_vis);
C=0.35*(ST/SL)^0.2;
(h*d/k)=(C*(Re^m)*(Pr^m)*((Pr/Prw)^0.25));
To=((Ti-Ts)*exp(-(pi*d*N*(h/3600)/(density*V*NT*ST*Cp))))+Ts;
LMTD=(((Ti-Ts)-(To-Ts))/(log((Ti-Ts)/(To-Ts))));
A=pi*d*L*N;
Q=h*A*LMTD;
//In book there is mistake in Npr calculation
//Due to the approximation and error in Npr calculation there is a huge difference in simulated value with the book ans
end Ex4_11;
