model Ex4_4
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A ball of ice, 4 cm in diameter, at 0 C is suspended in a dry air stream at 25 C which is following at a velocity of 2 m/s.&nbsp;<div>(a) What is the initial rate o melting of the ice?</div><div>(b) How much time would be needed to melt away 50% of the ice?</div><div>assume that the shape of the ice ball remains spherical all the time.&nbsp;</div><div>Will the rate of melting be affected by the presence of moisture in air?</div></body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
// data are given in the question
parameter Real lamda(unit="J/kg")=334000"Heat of fusion";
parameter Real density(unit="Kg/m^3")=1.248"Density of air";
parameter Real k(unit="W/m C")=0.026"Thermal conductivity of air";
parameter Real viscosity(unit="Kg/m S")=(1.69*10^(-5))"Viscosity of air";
parameter Real Cp(unit="J/Kg C")=1005"Specific heat of air";
parameter Real density_ice(unit="Kg/m^3")=920"Density of ice";
parameter Real d1(unit="m")=0.04"Initial Diameter of the ball";
parameter Real V(unit="m/s")=2"Velocity of air";
parameter Real Ta(unit="C")=25"Temperature of bulk air";
parameter Real Tb(unit="C")=0"Temperature of ice ball";
parameter Real dr(unit="m")=0.00001"Step size";
Real Nu1"initial Nusselt Number";
Real Re1"Initial Reynolds Number";
Real Pr"Prandtl Number";
Real h1(unit="W/m^2 C")"Initial Heat transfer Coefficient";
Real A1(unit="m^2")"Initial Area of heat transfer";
Real Q1(unit="W")"Initial Rate of Heat transfer";
Real r50(unit="m")"Radius at 50% melting";
Real Qr(unit="g/s")"Initial rate of melting";
Real[420] Re"Reynolds Number";
Real[420] Nu"Nusselt Number";
Real[420] h(unit="W/m^2 C")"Heat Transfer coefficient";
Real[421] t(unit="s")"Time of melting";
Real[421] r(unit="m")"Radius at any time";
Real t50(unit="s")"Time to rach 50 % melting";
Integer temp"Temporary variable";
equation
//Whitaker correlation is used
Nu1=(2+(0.4*(Re1^0.5)+(0.06*(Re1^(2/3))))*((Pr)^(0.4)));
Re1=(d1*V*density)/viscosity;
Pr=(Cp*viscosity/k);
Nu1=(h1*d1/k);
//subdivision (a)
A1=pi*(d1^2);
Q1=h1*A1*(Ta-Tb);
Qr=(Q1/lamda)*1000;
//Subdivision (b)
//Findout the radius at 50 % melting
0.5*((4/3)*pi*(d1/2)^3)=((4/3)*pi*(r50)^3);
// Backward diffence methord is used
r[1]=(d1/2);
t[1]=0;
for i in 1:420 loop
Re[i]=(2*r[i]*V*density/viscosity);
Nu[i]=(2+(0.4*(Re[i]^0.5)+(0.06*(Re[i]^(2/3))))*((Pr)^(0.4)));
Nu[i]=h[i]*2*r[i]/k;
t[i+1]=(lamda*density_ice/(h[i]*(Ta-Tb)))*dr+t[i];
r[i+1]=r[i]-dr;
end for;
temp=(((d1/2)-r50)/dr)+1;
t50=t[temp];
//There is slight difference in the simulated results with the book ans due to the approximation in the book
//Yes, The rate of melting will be affected by the presence of moisture in air
end Ex4_4;
