model Ex4_7
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Nitrogen gas is heated at a rate of 2000 kg/h before passing it through the trays in a tray drier in which an organic product is being dried. Medium pressure steam available from a waste heat boiler at a pressure of 5.7 bar (saturation temperatyure=160 C) condenses within the tubes of a \"finned tube\" heater. The gas flows outside the tubes. The heat duty is 38700 kcal/h. The specific heat of nitrogen can be taken as 0.239 kcal/kg c. The heat exchanger has an area efficiency is 63%. Calculate the inlet and the outlet temperature of the gas.</body></html>"));
parameter Real Q(unit="Kcal/hr")=38700"Heat duty";
parameter Real mg(unit="Kg/h")=2000"gas flow rate";
parameter Real Cp(unit="Kcal/kg C")=0.239"Specific heat of Nitrogen";
parameter Real efficiency=0.63"Efficiency of the fin";
parameter Real A(unit="m^2")=10"heat transfer area";
parameter Real U(unit="Kcal/ h m^2 C")=70"Overall heat transfer coefficient";
parameter Real Ts(unit="C")=160"Temerature of steam";
Real Ti(unit="C")"gas Inlet temperature";
Real To(unit="C")"gas outlet temperature";
Real LMTD(unit="C")"Log mean temperature difference";
equation
Q=(mg*Cp*(To-Ti));
Q=(U*A*LMTD*efficiency);
LMTD=(((Ts-Ti)-(Ts-To))/(log((Ts-Ti)/(Ts-To))));
// Due to the approximation in the book the simulated result is slightly deviated from the book results
end Ex4_7;
