model Ex4_8
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Hot water is flowing through a 3.5 cm (1-1/4'') schedule 40 steel pipe at a velocity of 1.8 m/s. The inlet temperature is 110 C and the length of the pipe is 15 m. A 2 cm thick layer of insulation (kc=0.12 W/m C) covers the pipe. The outside film coefficient is 10 W/m^2 C nd the ambient temperture is 20 C. Calculate the drop in the temperature of the water over this section of the pipe.</body></html>"));
//Data are given in the question statement
final constant Real pi=2*Modelica.Math.asin(1.0); 
parameter Real di(unit="m")=0.035 "Inner diameter of pipe";
parameter Real V(unit="m/s")=1.8"Velocity of pipe";
parameter Real Ti(unit="C")=110"Inlet temperature";
parameter Real L(unit="m")=15"Length of the pipe";
parameter Real ti(unit="m")=0.02"Thickness of insulation";
parameter Real kc(unit="W/m C")=0.12"Thermal conductivity of insulation";
parameter Real ho(unit="W/m^2 C")=10"Outside heat transfer coefficient";
parameter Real Ta(unit="C")=20"Ambient air temperature";
parameter Real t(unit="m")=0.0036"Thickness of pipe";   //1-1/4 schedule 40 pipe
parameter Real kw(unit="W/m C")=43"Thermal conductivity of pipe";
parameter Real density(unit="Kg/m^3")=950"Density of water";
parameter Real Cp(unit="J/Kg")=4230"Specific heat of water";
parameter Real viscosity(unit="Kg/m S")=(2.55*10^(-4))"Viscosity of water";
parameter Real k(unit="W/m C")=0.685"Thermal conductivity of water";
Real To(unit="C")"Outer temperature  of water";
Real Nu"Nusselt Number";
Real Re"Reynolds Number";
Real Pr"Prandtl Number";
Real ri(unit="m")"Inner radius of pipe";
Real r1(unit="m")"Outer radius of pipe";
Real ro(unit="m")"outer radius of insulation";
Real hi(unit="W/m^2 K")"Inner heat transfer coefficient";
Real Ui(unit="W/m^2 K")"Inner overall heat transfer coefficient";
Real Ai(unit="m^2")"Inner convective area";
Real mw(unit="kg/s")"mass flow rate of water";
Real LMTD(unit="C")"Log mean temeperature difference";
Real Q(unit="W")"Heat Transfer rate";
Real DelT(unit="C")"Drop in temperature";
equation 
ri=di/2;
r1=ri+t;
ro=r1+ti;
//Dittus - boether equation is used to fin out H.T.C
Nu=0.023*((Re)^0.8)*(Pr^0.3);
Re=(di*V*density/viscosity);
Pr=(Cp*viscosity/k);
(1/Ui)=(1/hi)+((ri*log(r1/ri))/kw)+((ri*log(ro/r1))/kc)+(ri/(ro*ho));
Nu=hi*di/k;
Ai=pi*di*L;
mw=pi*(ri^2)*V*density;
LMTD=(((Ti-Ta)-(To-Ta))/(log((Ti-Ta)/(To-Ta))));
Q=mw*Cp*(Ti-To);
Q=Ui*Ai*LMTD;
DelT=Ti-To;
//In book The drop in temperature is not found out. DelT is the drop in temperature in simulated result
end Ex4_8;
