model Ex4_9
//Problem statements is given in the Documentation view
annotation(
    Documentation(info = "<html><head></head><body>A 41 mm i.d (1-1/2'' nominal bore) schedule 40 pipe carries water flowing at a rate of 1 kg/s. Water enters the pipe at 28 C and is heated by a stream of hot flue gas in cross flow ovewr th epipe. The gas velocity is 10 m/s. The arrangemet essentially aims at recovering a part of the waste heat of the gas stram which has a bulk temeperature of 250 C. The pressure is essentially atmoshperic. The length of the pipe is 20 m. At what temperature does the water leave the pipe? The properties of the flue gas are about the same as those of the air.</body></html>"));
  final constant Real pi=2*Modelica.Math.asin(1.0);
  // Data are given in the problem statement
  //data of water
  parameter Real density(unit = "Kg/m^3") = 996 "density of water";
  parameter Real Cp(unit = "Kcal/Kg C") = 1.0 "Specific heat of water";
  parameter Real viscosity(unit = "Kg/m C") = 8.6 * 10 ^ (-4) "Viscosity of water";
  parameter Real kw(unit = "Kcal/h m C") = 0.528 "Thermal conductivity of water";
  parameter Real mw(unit = "kg/h") = 3600 "Mass flow rate of water";
  //Data of flue gas
  parameter Real rof(unit = "kg/m^3") = 0.891 "Density of flue gas";
  parameter Real Cpf(unit = "Kcal/kg C") = 0.243 "Specific heat of flue gas";
  parameter Real visf(unit = "Kg/m S") = 2.33 * 10 ^ (-5) "Viscosity of flue gas";
  parameter Real ka(unit = "kcal/h m C") = 0.0292 "Thermal conductivity of flue gas";
  parameter Real di(unit = "m") = 41 * 10 ^ (-3) "Inner diameter of the pipe";
  parameter Real Vf(unit = "m") = 10 "Velocity of flue gas";
  parameter Real t(unit = "m") = 0.0037 "Thickness of the pipe";
  parameter Real To(unit = "C") = 250 "Flue gas temperature";
  parameter Real T1(unit = "C") = 28 "Inlet water temperature";
  parameter Real L(unit = "m") = 20 "Length of the pipe";
  Real T2(unit = "C") "Outlet temperature of water";
  Real Prf "Prandtl Number of flue gas";
  Real Ac(unit = "m^2") "Cross sectional area of pipe";
  Real V(unit = "m/s") "Velocity of water";
  Real Re "Reynolds number of water";
  Real Pr "Prandtl Number of water";
  Real Nui "Inner Nusselt number";
  Real hi(unit = "Kcal/h m^2 C") "Inner heat transfer coefficient";
  Real Nuo "Outside Nusselt number";
  Real Ref "Outside Reynolds number";
  Real do(unit = "m") "Outer diameter of pipe";
  Real ho(unit = "Kcal/h m^2 C") "outer heat transfer coefficient";
  Real Uo(unit = "Kcal/h m^2 C") "Outside overall heat transide coefficient";
  Real LMTD(unit = "C") "Log mean temperature difference";
  Real Ao(unit = "m^2") "Outer Convective area";
equation
  Prf = visf * Cpf / (ka / 3600);
  Ac = pi / 4 * di ^ 2;
  mw / 3600 = V * Ac * density;
  Re = di * V * density / viscosity;
  Pr = viscosity * Cp / (kw / 3600);
  Nui = 0.023 * Re ^ 0.8 * Pr ^ 0.4;
  Nui = hi * di / kw;
  Nuo = 0.3 + 0.62 * Ref ^ 0.5 * Prf ^ (1 / 3) / (1 + (0.4 / Prf) ^ (2 / 3)) ^ (1 / 4) * (1 + (Ref / (2.82 * 10 ^ 5)) ^ (5 / 8)) ^ (4 / 5);
  Ref = do * Vf * rof / visf;
  do = di + 2 * t;
  Nuo = ho * do / ka;
  1 / Uo = do / (di * hi) + 1 / ho;
//Thermal resistance due to wall is neglected
  LMTD = (To - T1 - (To - T2)) / log((To - T1) / (To - T2));
//Heat balance
  mw * Cp * (T2 - T1) = Uo * Ao * LMTD;
  Ao = pi * L * do;
 
end Ex4_9;
