model Ex5_2
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A thin metel plate 1m*1m is placed on a rooftop. It receives radiant heat from the sun directly at the rate of 170 W/m^2. If heat transfer from the plate to the ambient occurs purely by free convection, calculate the steady state temperature of the plate. Assume that there is no heat loss from the bottom of the plate. The ambient temperature is 25 C.</body></html>"));
//It is a Iterative calculation. According to book the ans converges at the end of the first iteration itself
//properties are taken at mean temperature
parameter Real Ta(unit="C")=25"Ambient temperature";
parameter Real q(unit="W/m^2")=170"Heat transfer flux";
parameter Real Ts1(unit="C")=60"Assumed Plat temperature";
parameter Real ki_vis(unit="m^2/s")=(1.85*10^(-5))"Kinamatic Viscosity";
parameter Real Pr=0.7"Prandtl Number";
parameter Real k(unit="W/m C")=0.028"Thermal conductivity of air";
parameter Real g(unit="m/s^2")=9.8"Gravitational accelaration";
parameter Real A(unit="m^2")=1"Area of the plate";
parameter Real P(unit="m")=4"perimeter";
Real L(unit="m")"Characteristic length";
Real Tm(unit="K")"Mean Temperature";
Real beta(unit="K^-1")"Thermal expansion coefficient";
Real Gr"Grashof Number";
Real Ra"Rayleigh Number";
Real Nu"Nusselt Number";
Real h(unit="W/m^2 C")"Heat Transfer coefficient";
Real Ts(unit="C")"Plate temperature";
equation 
Tm=((Ta+Ts1)/2)+273;
L=(A/P);
beta=(1/Tm);
Gr=((g*beta*(Ts1-Ta)*(L^3))/(ki_vis^2));
Ra=(Gr*Pr);
Nu=(0.54*(Ra^(1/4)));
Nu=(h*L/k);
q=h*(Ts-Ta);
end Ex5_2;
