model Ex5_3
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A long horizontal cylindrical carbon steel rod , 2.54 cm in diameter and 40 cm long at 80 C cools down by free convection heat transfer to an ambient at 30 C. Calculate the time required for cooling of the rod down to 35 C. Assume that the temperature of the rod remains uniform at any instant(lumped parameter model). The following simpkle correlation (applicable for free convection heat transfer from a horizontal cylinder in air) may be used: h=1.32*(del T/d)^0.25 W/m^2 C. where del T (in C) is the temperature difference between the surface and the ambient and d(in m ) is the diameter of the cylinder. For carbon steel, Density=7800 kg/m^3, Cp=0.473 KJ/KgC.</body></html>"));
 final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real d(unit="m")=0.025 "Diameter of the cylinder";
parameter Real l(unit="m")=0.4 "Length of the cylinder";
parameter Real density(unit="Kg/m^3")=7800"Density of the cylinder";
parameter Real Cp(unit="J/kg C")=473"Specific heat capacity of cylinder";
parameter Real Ti(unit="C")=80"Initial temperature of rod";
parameter Real Tf(unit="C")=35"Final Temperature";
parameter Real Ta(unit="C")=30"Ambient temperature";
parameter Real dT(unit="C")=0.05"Step size";
Real m(unit="Kg")"mass of the cylinder";
Real A(unit="m^2")"Heat trasnfer area";
Real[900] h(unit="W/m^2 C")"Heat trasnfer coefficient";
Real[901] t(unit="s")"Time of cooling";
Real[901] T(unit="C")"Temperature difference at any time";
Real t35(unit="hour")"Time to cool the rod to 35 C";
Integer temp"Temporary variable";
equation
m=((pi/4)*(d^2)*l*density);
//The area of the flat surface is neglected
A=pi*d*l;
//Time required to reach 35 C is found by backward difference method
// Initial condition
t[1]=0;
T[1]=(Ti-Ta);
for i in 1:900 loop
h[i]=1.32*((T[i]/d)^0.25);
t[i+1]=((m*Cp/(h[i]*A))*(1/T[i]))*dT+(t[i]);
T[i+1]=T[i]-dT;
end for;
temp=((Ti-Tf)/dT)+1;
t35=(t[temp])/3600;
// Since numerical technic is used here, there is a slight difference in the answer with the book answer. If the step size is reduced the answer will be more accurate, but it will take very long time for the computer to simulate the answer
end Ex5_3;
