model Ex5_6
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A refrigirator is placed near the partition wall of a room such that there is only a 4 cm gap in between. The surface of the refrigeratior facing the wall is 1.6 m in height and 0.8 m in breadth. if the temperature of the surface is 22 C and the wall temperature is 30 C. Calculate teh rate of heat gain by the cooler surface.</body></html>"));
//Data are take from the book
parameter Real L(unit="m")=1.60"Height of the enclosure";
parameter Real w(unit="m")=0.04"Width of the enclosure";
parameter Real Ts(unit="C")=22"SUrface temperature";
parameter Real Tw(unit="C")=30"Wall temperature";
parameter Real Pr=0.7"Prandtl Number";
parameter Real ki_vis(unit="m^2/s")=1.684*10^(-5)"Kinamatic viscosity of air";
parameter Real k(unit="W/m C")=0.026"Thermal conductivity of air";
parameter Real alpha(unit="m^2/S")=2.21*10^(-5)"Thermal diffusivity";
parameter Real g(unit="m/s^2")=9.8"Gravitational acceleration";
parameter Real b(unit="m")=0.8"Breadth of the enclosure";
Real Tm(unit="C")"Mean air temperataure";
Real L_by_w"L/w ratio";
Real beta(unit="K^-1")"Thermal expansion coefficient";
Real Ra"Rayleigh Number";
Real Nu"Nusselt Number";
Real h(unit="W/m^2 C")"Heat transfer Coefficient";
Real Q(unit="W")"Rate of heat gain";
Real A(unit="m^2")"Area of heat transfer";
equation
Tm=((Tw+Ts)/2);
L_by_w=(L/w);
beta=(1/(Tm+273));
Ra=((g*beta*(Tw-Ts)*(w^3))/(ki_vis*alpha));
Nu=(0.42*(Ra^0.25)*(Pr^0.012)*(L_by_w)^(-0.3));
Nu=(h*w/k);
Q=(h*A*(Tw-Ts));
A=(L*b);
end Ex5_6;
