model Ex6_2
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Calculte the rate of boiling of water in a 0.35 m diameter stainless steel pan at 1 atm pressure if the bottom of the pan is maintained at 115 C.</body></html>"));
  final constant Real pi = 2 * Modelica.Math.asin(1.0);
  //Data are given in the problem statement
  parameter Real Tp(unit = "C") = 115 "Pan temperature";
  parameter Real Tb(unit = "C") = 100 "Boiling point of water at 1 atm";
  parameter Real P(unit = "bar") = 1.013 "Pressure";
  //Property of water at 100 C
  parameter Real viscosity(unit = "N S/m^2") = 2.79 * 10 ^ (-4) "Viscosity of water";
  parameter Real Cp(unit = "KJ/kg C") = 4.22 "Specific heat capacity";
  parameter Real density(unit = "kg/m^3") = 958 "Density of water";
  parameter Real Lv(unit = "KJ/Kg") = 2257 "Latend heat of vaporization";
  parameter Real sur_ten(unit = "N/m") = 0.059 "Surface tension of water";
  parameter Real Pr = 1.76 "Prandtl Number";
  parameter Real ro_v(unit = "Kg/m^3") = 0.5955 "Density of steam";
  parameter Real Csf = 0.013 "Constant for SS";
  parameter Real n = 1 "Constant for water";
  parameter Real g(unit = "m/s^2") = 9.8 "Gravitational acceleration";
  parameter Real d(unit = "m") = 0.35 "Diameter of pan";
  parameter Real Pc(unit = "bar") = 221.2 "Critical pressure of water";
  Real Te(unit = "C") "Excess temperature for boiling";
  Real pr "Reduced pressure";
  Real qs_T(unit = "KW/m^2") "Heat flux by Rohsenow's correlation";
  Real m(unit = "Kg/h") "Rate of boiling";
  Real A(unit = "m^2") "Boiling area";
  Real qmax(unit = "KW/m^2") "Critical Heat flux by Lienhard's correlation";
  Real hb(unit = "KW/m^2 C") "Boiling Heat transfer coefficient";
  Real q(unit = "KW") "Heat flux";
equation
  Te = Tp - Tb;
  qs_T = viscosity * Lv * (g * (density - ro_v) / sur_ten) ^ (1 / 2) * (Cp * Te / (Csf * Lv * Pr ^ n)) ^ 3;
  A = pi / 4 * d ^ 2;
  m = qs_T / Lv * A * 3600;
  qmax = 0.149 * Lv * ro_v * (sur_ten * g * (density - ro_v) / ro_v ^ 2) ^ (1 / 4);
//The actual heat flux is less than the critical heat flux
  hb * 1000 = 0.00341 * Pc ^ 2.3 * Te ^ 2.33 * pr ^ 0.566;
  pr = P / Pc;
  q = hb * Te;
//It is reasonable to compare actual the heat flux (q) with the heat flux by Rohsenow equation (qs_T)
end Ex6_2;
