model Ex6_5
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Saturated propane vapour at 32 C condenses on a vertical surface, 0.3 m high, at a pressure of 11.2 atm. The surface is maintaine at 25 C. Calculate the rate of condensation of propane.</body></html>"));
// Data are given in problem statement
parameter Real density(unit="Kg/m^2")=483"Density of propane";
parameter Real viscosity(unit="Kg/m S")=9.1*10^(-5)"Viscosity of propane";
parameter Real k(unit="W/m K")=0.09"Thermal conductivity of propane";
parameter Real Lv(unit="KJ/Kg")=326"Latent heat of vaporization";
parameter Real Cp(unit="KJ/Kg K")=2.610"Specific heat capacity of propane";
parameter Real ro_v(unit="Kg/m^3")=24.7"Density of vapour";
parameter Real Tv(unit="C")=32"Vapour temperature";
parameter Real Tw(unit="C")=25"Surface temperature";
parameter Real Re=30"Reynolds Number";
parameter Real l(unit="m")=0.3"Total Characteristic length";
parameter Real g(unit="m/s^2")=9.8"Gravitational acceleration";
Real Lv1(unit="KJ/Kg")"Modified latent heat of vaporization";
Real L(unit="m")"Characteristic length to which the flow is laminar";
Real Q(unit="W")"Heat transfer rate at laminar region";
Real m(unit="Kg/s")"Rate of condensation";
Real L1(unit="m")"Characteristic length at which flow is wavy";
Real h1(unit="W/m^2 C")"Heat transfer coefficient for wavy flow";
Real m_T(unit="Kg/h")"Total rate of condensation";
equation
Lv1=Lv+(0.68*Cp*(Tv-Tw));
m=(Re/(4/viscosity));
Q=((Lv1*1000)*m);
((L^(3/4))*1)=Q/((((0.943*(((g*(Lv1*1000)*density*(density-ro_v)*(k^3)))^(1/4)))/(viscosity*(Tv-Tw))^(1/4)))*(Tv-Tw));
L1=l-L;
((h1/k)*(((viscosity^2)/(density*(density-ro_v)*g))^(1/3)))=(((4*(m_T/3600))/viscosity)/((1.08*(((4*(m_T/3600))/(viscosity))^1.22))-5.2));
(m_T/3600)=(m+((h1*(L1*1)*(Tv-Tw))/(Lv1*1000)));
//Since iterative solver is used in modelica, to get a converged solution the equations are rearranged.
end Ex6_5;
