model Ex7_17
//Problem statements is given in the Documentation view
annotation(
    Documentation(info = "<html><head></head><body>Two parallel directly opposed (i.e coaxial) annular disk are maintained at temperature 1000 K and 300 K respectively. The disks have the following dimensions and emissivities.<div>Disk-1(1000 K): Inner radius=10cm, outer radius =20 cm, &nbsp;emissivity =0.8</div><div>Disk-2(300 K): Inner radius =12cm, outer radius =25 cm, emissivity =0.7</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>If the distance between the disk is 8 cm, what is the net rate of exchange of radiation- free environment (that is , in an environment at absolute zero temperature)</div></body></html>"));
parameter Real r1(unit="m")=0.1 "Inner radii of disc 1";
parameter Real r2(unit="m")=0.2 "Outer radii of disc 1";
parameter Real r3(unit="m")=0.12"Inner radii of disc 2";
parameter Real r4(unit="m")=0.25 "Outer radii of disc 2";
parameter Real h(unit="m")=0.08 "Height";
parameter Real T1(unit="K")=1000 "Temperature 1";
parameter Real T2(unit="K")=300 "Temperature 2";
parameter Real S(unit="W/m^(4)")=5.67*10^(-8) "Stefan Boltzmann constant";
parameter Real E1(unit="No units")=0.8 "Emissivity from surface 1";
parameter Real E2(unit="No units")=0.7 "Emissivity form surface 2";
Real R1(unit="m")" Radius 1";
Real R2(unit="m") "Radius 2";
Real R3(unit="m") "Radius 3";
Real R4(unit="m") "Radius 4";
Real X(unit="No units");
Real X1(unit="No units");
Real X2(unit="No units");
Real X3(unit="No units");
Real F1(unit="No units") "View factor";
Real F2(unit="No units") "View factor";
Real F3(unit="No units") "View factor";
Real F4(unit="No units") "View factor";
Real F12(unit="No units") "Fraction of emission from surface 1 to 2";
Real F1s(unit="No units") "Fraction of radiation at surface 1";
Real F2s(unit="No units") "Fraction of radiation at surface 2";
Real A1(unit="m^(2)") "Area 1";
Real A2(unit="m^(2)") "Area 2";
Real A3(unit="m^(2)") "Area 3";
Real A4(unit="m^(2)") "Area 2&3";
Real FA1(unit="No units") "Factor 1";
Real FA2(unit="No units") "Factor 2";
Real FA3(unit="No units") "Factor 3";
Real FA4(unit="No units") "Factor 4";
Real FA5(unit="No units") "Factor 5";
Real Eb1(unit="W") "Emission power 1";
Real Eb2(unit="W") "Emission power 2";
Real J1(unit="W/m^(2)") "Radiosity 1";
Real J2(unit="W/m^(2)") "Radiosity 2";
Real Q(unit="W/m^(2)") "Rate of radiation heat exchange";
//For better understanding refer fig 7.31 (pg.no-252)"Heat transfer principles and applications" by Binay K Dutta 
equation
R1=r2/h;
R2=r4/h;
X=1+(1+R1^(2))/R2^(2);
F1=(1/2)*(X-sqrt(X^(2)-4*(R1/R2)^(2)));
R3=r1/h;
X1=1+(1+R3^(2))/R2^(2);
F2=(1/2)*(X1-sqrt(X1^(2)-4*(R3/R2)^(2)));
R4=r3/h;
X2=1+(1+R1^(2))/R4^(2);
F3=(1/2)*(X2-sqrt(X2^(2)-4*(R1/R4)^(2)));
X3=1+(1+R3^(2))/R4^(2);
F4=(1/2)*(X3-sqrt(X3^(2)-4*(R3/R4)^(2)));
A4=3.14*(r4)^(2);
A3=3.14*(r3)^(2);
A1=3.14*(r2^(2)-r1^(2));
A2=3.14*(r4^(2)-r3^(2));
F12=(A4/A1)*(F1-F2)-(A3/A1)*(F3-F4);
F1s=1-F12;
F2s=1-((A1*F12)/A2);
FA1=(1-E1)/(E1*A1);
FA2=(1-E2)/(E2*A2);
FA3=1/(A2*F2s);
FA4=1/(A1*F12);
FA5=1/(A1*F1s);
Eb1=S*T1^(4);
Eb2=S*T2^(4);
(Eb1-J1)/FA1=((J1-J2)/(FA4))+(J1)/(FA5);
(Eb2-J2)/FA2=((J2-J1)/(FA4))+(J2)/(FA3);
Q=(J1-J2)/(FA4);
//Due to the approximation there is slight difference in the simulated result with the book ans
end Ex7_17;
