model Ex7_19
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A rectangular oven of 1.5m*1m cross-section an dthe 1m height (all inside dimensions) is insulated with 7.5 cm thick fibre glass blanket (k=0.08 W/m C). The oven has outer walls made of carbon steel sheets which do no offer any appreciable heat transfer resistance. The bottom surface is maintained t 300 C. Heat loss occurs from the outer surfaces (top and side walls) by combined radiation natural convection to an ambient at 30 C. Natural convection heat transfer coefficients can be estimated by using the following correlations<div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>ht=1.43(delT)^(1/3) W/m^2 C &nbsp; (for the top surface)</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>hs=0.601(delT/l)^(1/5) &nbsp;W/m^2 C &nbsp; &nbsp; (for the side walls)<span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span></div><div>where delT=Temperature driving force</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>&nbsp; &nbsp;l=height of the side wall</div><div>All teh surfaces are essentially black. Calculate the suface temperatures (both inside and outside) and the total rate of heat loss from the oven.</div></body></html>"));
parameter Real T1(unit="K")=573"Temperature of bottom surface";
parameter Real Ta(unit="K")=303"Temperature of ambient air";
parameter Real w(unit="m")=0.075"Thickness of the fibre glass blanket";
parameter Real K(unit="W/m C")=0.08"Thermal conductivity of fibre glass blanket";
parameter Real l(unit="m")=1.075"Outside height of side wall";
parameter Real SB(unit="W/m^2 K^4")=5.669*10^(-8)"Stefan boltzmann constant";
parameter Real L(unit="m")=1"length of the rectangular over";
parameter Real b(unit="m")=1.5"Width of the rectangular over";
parameter Real h(unit="m")=1"Height of the oven";
parameter Real F21=0.252"View factor of 2-1";  //From the graph (fig) 7.12 -Heat transfer priciples and appications by Binay K Dutta
parameter Real F22=0"View factor 2-2";
Real A1(unit="m^2")"Area of bottom surface";
Real A2(unit="m^2")"Area of top surface";
Real A2_o(unit="m^2")"Outer Area of top surface";
Real A2_m(unit="m^2")"Mean area of top surface";
Real A3(unit="m^2")"Total inside area of all side walls";
Real A3_o(unit="m^2")"Total outside area of all side walls";
Real A3_m(unit="m^2")"Mean area of all side walls";
Real ht(unit="W/m^2 C")"HTC of top surface";
Real hs(unit="W/m^2 C")"HTC of side wall";
Real T2(unit="K")"inner Temperature of top surface";
Real T3(unit="K")"inner Temperature of side wall";
Real T2_o(unit="K")"outer Temperature of top surface";
Real T3_o(unit="K")"outer Temperature of side wall";
Real F23"View factor 2-3";
Real F13"View factor 1-3";
Real Qt(unit="W")"Heat loss rate at the top surface";
Real Qs(unit="W")"Heat loss rate from side wall";
Real Q(unit="W")"Total heat rate loss";
equation
A1=(L*b);
A2=(L*b);
A2_o=((L+(2*w))*(b+(2*w)));
A2_m=(A2+A2_o)/2;
A3=2*((h*b)+(h*L));
A3_o=2*((l*(b+(2*w)))+(l*(L+(2*w))));
A3_m=(A3+A3_o)/2;
(ht^3)=(((1.43)^3)*((T2_o-Ta)));
(hs^5)=(((1.43)^5)*((T3_o-Ta)));
F23=(1-(F21+F22));
F13=F23;  //Similar geometry
//Heat balance
//For top surface
((A2*F21*SB*((T1^4)-(T2^4)))+(A2*F23*SB*((T3^4)-(T2^4))))=((A2_o*ht*(T2_o-Ta))+(A2_o*SB*((T2_o^4)-(Ta^4))));
((A2_m)*(K/w)*(T2-T2_o))=((A2_o*ht*(T2_o-Ta))+(A2_o*SB*((T2_o^4)-(Ta^4))));
//For side walls
((A1*F13*SB*((T1^4)-(T3^4)))-(A2*F23*SB*((T3^4)-(T2^4))))=((A3_o*hs*(T3_o-Ta))+(A3_o*SB*((T3_o^4)-(Ta^4))));
((A3_m)*(K/w)*(T3-T3_o))=((A3_o*hs*(T3_o-Ta))+(A3_o*SB*((T3_o^4)-(Ta^4))));
//Heat loss
Qt=((A2_m)*(K/w)*(T2-T2_o));
Qs=((A3_m)*(K/w)*(T3-T3_o));
Q=(Qt+Qs);
//Due to the approximation in the book calculation, there is slight sifference in simulated results with the book ans
end Ex7_19;
