model Ex7_5
//Problem statements is given in the Documentation view
annotation(
    Documentation(info = "<html><head></head><body>The spectral emissivity of a non gray surface at 1500 K can be approximated by a step function of wavelength as shown in fig(refer pg.no 219 - Heat transfer principles and application by Binay K Dutta). Calculate<div>(a) The total (hemispherical) Emissivie power</div><div>(b) The total (hemispherical) Emissivity.</div></body></html>"));
parameter Real E1lamda(unit="lamda")=0.2 "Spectral emissivity between 0 and 2";
parameter Real E2lamda(unit="lamda")=0.6 "Spectral emissivity between 2 and 6";
parameter Real E3lamda(unit="lamda")=0.1 "Spectral emissivity between 6 and 10";
parameter Real T(unit="K")=1500 "Temperature";
parameter Real sigma(unit="W/K^(4)")=5.669*10^(-8)"Boltzmann constant";
parameter Real F1(unit="No units")=0.2733 "Fraction of radiation between 0 and 2";
parameter Real F2(unit="No units")=0.6167 "Fraction of radiation between 2 and 6";
parameter Real F3(unit="No units")=0.0789 "Fraction of radiation between 6 and 10";
Real E(unit="W/m^(2)") "Total emissive power";
Real Epsilon(unit=" No units") "Total hemispherical emissivity";
equation
E=((E1lamda*F1)+(E2lamda*F2)+(E3lamda*F3))*sigma*T^(4);
Epsilon=E/(sigma*T^(4));
//Due to the approximation in the book calculation, There is a slight difference in simulated results with the book ans
end Ex7_5;
