model Ex7_6
//Problem statements is given in the Documentation view
annotation(
    Documentation(info = "<html><head></head><body>Consider a small plane surface area dA1 directly opposed to a circular ring A2 of inner radius 5 cm and width 3 cm. Calculate the fraction of the radiation emitted by the surface dA1 that is intercepted by the ring (area= A2') and also the fraction that passes through the hole (area=A2'') in the ring if the surface are placed 20 cm apart. The geometry is illustrated in fig 7.15 (p.no 227- \"Heat transfer principles and applications\" by Binay K Dutta)</body></html>"));
parameter Real L(unit="cm")=20 "Length";
parameter Real r0(unit="cm")=5 "Inner radius";
parameter Real ri(unit="cm")=3 "Width";
Real r(unit="cm") "Total radius";
Real F(unit="No units") "Fraction of radiation that passes through the hole";
Real F1(unit="No units") "Fraction of radius intercepted by the ring";
equation
//Refer the derivation in the book// p.no-226 ("Heat transfer principles and application" by Binay K Dutta)
F=(r0^(2))/((L^(2))+(r0^(2)));
r=r0+ri;
F1=L^(2)*((1/((L^(2))+r0^(2)))-(1/((L^(2))+(r^(2)))));
end Ex7_6;
